/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.environment.se.StartMain;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.repositories.RepositoryServiceImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;

@Ignore
public class RepositoryCreationTest {
    private static final String SCHEME = "git";
    private static final String DROOLS_WB_PLAYGROUND_ALIAS = "uf-playground";
    private static final String DROOLS_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/guvnorng-playground.git";
    private static final String JBPM_WB_PLAYGROUND_ALIAS = "jbpm-playground";
    private static final String JBPM_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground-kjar.git";
    private BeanManager beanManager;
    private RepositoryServiceImpl repositoryService;
    private IOService ioService;

    @Before
    public void setUp() throws Exception {
        StartMain startMain = new StartMain(new String[0]);
        this.beanManager = startMain.go().getBeanManager();
        Bean repoService = (Bean)this.beanManager.getBeans(RepositoryServiceImpl.class, new Annotation[0]).iterator().next();
        Bean ioServiceBean = (Bean)this.beanManager.getBeans("ioStrategy").iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)repoService);
        this.repositoryService = (RepositoryServiceImpl)this.beanManager.getReference(repoService, RepositoryServiceImpl.class, cc);
        this.ioService = (IOService)this.beanManager.getReference(ioServiceBean, IOService.class, cc);
    }

    @Test
    public void test() throws InterruptedException {
        Repository drools = this.repositoryService.createRepository(SCHEME, DROOLS_WB_PLAYGROUND_ALIAS, (Map)new HashMap<String, Object>(){
            {
                this.put("origin", RepositoryCreationTest.DROOLS_WB_PLAYGROUND_ORIGIN);
            }
        });
        Repository jbpm = this.repositoryService.createRepository(SCHEME, JBPM_WB_PLAYGROUND_ALIAS, (Map)new HashMap<String, Object>(){
            {
                this.put("origin", RepositoryCreationTest.JBPM_WB_PLAYGROUND_ORIGIN);
            }
        });
        Assert.assertNotNull((Object)drools);
        Assert.assertNotNull((Object)jbpm);
        Thread.sleep(2000L);
        this.ioService.write(Paths.convert((Path)drools.getRoot()).resolve("new_file.txt"), "some new content", new OpenOption[0]);
        Assert.assertEquals((Object)"some new content\n", (Object)this.ioService.readAllString(Paths.convert((Path)drools.getRoot()).resolve("new_file.txt")));
        Thread.sleep(2000L);
        this.ioService.write(Paths.convert((Path)drools.getRoot()).resolve("new_file.txt"), "some new content 2", new OpenOption[0]);
        Assert.assertEquals((Object)"some new content 2\n", (Object)this.ioService.readAllString(Paths.convert((Path)drools.getRoot()).resolve("new_file.txt")));
        this.repositoryService.removeRepository(DROOLS_WB_PLAYGROUND_ALIAS);
        this.repositoryService.removeRepository(JBPM_WB_PLAYGROUND_ALIAS);
    }
}

