/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.uberfire.backend.server.security.FileSystemAuthorizationManager;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.backend.server.security.IOSecurityAuth;
import org.uberfire.backend.server.security.IOSecurityAuthz;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.security.SecurityAware;
import org.uberfire.java.nio.security.Session;
import org.uberfire.java.nio.security.UserPassAuthenticator;
import org.uberfire.security.Resource;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.RolesMode;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.server.UserPassSecurityContext;
import org.uberfire.security.server.auth.impl.JAASAuthenticationManager;
import org.uberfire.security.server.auth.impl.PropertyAuthenticationManager;

@ApplicationScoped
@Startup
public class IOServiceSecuritySetup {
    @Inject
    @IOSecurityAuth
    @Any
    private Instance<AuthenticationManager> authenticationManagers;
    @Inject
    @IOSecurityAuthz
    @Any
    private Instance<AuthorizationManager> authorizationManagers;

    @PostConstruct
    public void setup() {
        Object _authenticationManager = null;
        FileSystemAuthorizationManager _authorizationManager = null;
        if (this.authenticationManagers.isUnsatisfied()) {
            RolesMode mode;
            String authType = System.getProperty("org.uberfire.io.auth", null);
            String domain = System.getProperty("org.uberfire.domain", null);
            String _mode = System.getProperty("org.uberfire.roles.mode", RolesMode.GROUP.toString());
            try {
                mode = RolesMode.valueOf((String)_mode);
            }
            catch (Exception ignore) {
                mode = RolesMode.GROUP;
            }
            _authenticationManager = authType == null || authType.toLowerCase().equals("jaas") || authType.toLowerCase().equals("container") ? new JAASAuthenticationManager(domain, mode) : (authType.toLowerCase().equals("property") ? new PropertyAuthenticationManager(null) : this.loadClazz(authType, AuthenticationManager.class));
        }
        if (this.authorizationManagers.isUnsatisfied()) {
            _authorizationManager = new FileSystemAuthorizationManager();
        }
        final FileSystemAuthorizationManager authorizationManager = _authorizationManager;
        JAASAuthenticationManager authenticationManager = _authenticationManager;
        org.uberfire.java.nio.security.AuthorizationManager ioAuthorizationManager = new org.uberfire.java.nio.security.AuthorizationManager(){

            public boolean authorize(FileSystem fs, org.uberfire.java.nio.security.Subject subject) {
                return authorizationManager.authorize((Resource)new FileSystemResourceAdaptor(fs), ((SubjectWrapper)subject).getRealSubject());
            }
        };
        for (FileSystemProvider fileSystemProvider : FileSystemProviders.installedProviders()) {
            if (!(fileSystemProvider instanceof SecurityAware)) continue;
            ((SecurityAware)fileSystemProvider).setUserPassAuthenticator(new UserPassAuthenticator((AuthenticationManager)authenticationManager){
                final /* synthetic */ AuthenticationManager val$authenticationManager;
                {
                    this.val$authenticationManager = authenticationManager;
                }

                public boolean authenticate(String username, String password, Session session) {
                    try {
                        Subject result = this.val$authenticationManager.authenticate((SecurityContext)new UserPassSecurityContext(null, username, password));
                        if (result != null) {
                            session.setSubject((org.uberfire.java.nio.security.Subject)new SubjectWrapper(result));
                        }
                        return result != null;
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                }
            });
            ((SecurityAware)fileSystemProvider).setAuthorizationManager(ioAuthorizationManager);
        }
    }

    private <T> T loadClazz(String clazzName, Class<T> typeOf) {
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (!typeOf.isAssignableFrom(clazz)) {
                return null;
            }
            return typeOf.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (InstantiationException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    class SubjectWrapper
    implements org.uberfire.java.nio.security.Subject {
        private final Subject realSubject;

        SubjectWrapper(Subject realSubject) {
            this.realSubject = realSubject;
        }

        public String getName() {
            return this.realSubject.getName();
        }

        public Subject getRealSubject() {
            return this.realSubject;
        }
    }
}

