/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.io.IOSecurityAuth;
import org.uberfire.backend.server.repositories.RepositoryServiceImpl;
import org.uberfire.backend.server.repositories.SystemRepository;
import org.uberfire.backend.server.security.JAASAuthenticationService;
import org.uberfire.backend.server.security.RepositoryAuthorizationManager;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.io.impl.cluster.IOServiceClusterImpl;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class ConfigIOServiceProducer {
    @Inject
    private RepositoryServiceImpl repositoryService;
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    @Inject
    @IOSecurityAuth
    private Instance<AuthenticationService> applicationProvidedConfigIOAuthService;
    private IOService configIOService;

    @PostConstruct
    public void setup() {
        this.configIOService = this.clusterServiceFactory == null ? new IOServiceNio2WrapperImpl("config") : new IOServiceClusterImpl((IOService)new IOServiceNio2WrapperImpl("config"), this.clusterServiceFactory, this.clusterServiceFactory.isAutoStart());
        JAASAuthenticationService authenticationService = this.applicationProvidedConfigIOAuthService.isUnsatisfied() ? new JAASAuthenticationService("ApplicationRealm") : (AuthenticationService)this.applicationProvidedConfigIOAuthService.get();
        this.configIOService.setAuthenticationManager((AuthenticationService)authenticationService);
        this.configIOService.setAuthorizationManager((AuthorizationManager)new RepositoryAuthorizationManager(this.repositoryService));
    }

    @PreDestroy
    public void onShutdown() {
        this.configIOService.dispose();
    }

    @Produces
    @Named(value="configIO")
    public IOService configIOService() {
        return this.configIOService;
    }

    @Produces
    @Named(value="system")
    public Repository systemRepository() {
        return SystemRepository.SYSTEM_REPO;
    }
}

