/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.NewRepositoryEvent;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryAlreadyExistsException;
import org.uberfire.backend.repositories.RepositoryInfo;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.repositories.impl.PortableVersionRecord;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.config.SystemRepositoryChangedEvent;
import org.uberfire.backend.server.repositories.RepositoryFactory;
import org.uberfire.backend.server.repositories.SystemRepository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DeleteOption;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    private static final int HISTORY_PAGE_SIZE = 10;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="system")
    private Repository systemRepository;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private RepositoryFactory repositoryFactory;
    @Inject
    private Event<NewRepositoryEvent> event;
    private Map<String, Repository> configuredRepositories = new HashMap<String, Repository>();
    private Map<Path, Repository> rootToRepo = new HashMap<Path, Repository>();

    @PostConstruct
    public void loadRepositories() {
        List repoConfigs = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (repoConfigs != null && !repoConfigs.isEmpty()) {
            for (ConfigGroup config : repoConfigs) {
                Repository repository = this.repositoryFactory.newRepository(config);
                this.configuredRepositories.put(repository.getAlias(), repository);
                this.rootToRepo.put(repository.getRoot(), repository);
            }
        }
        this.ioService.onNewFileSystem(new IOService.NewFileSystemListener(){

            public void execute(org.uberfire.java.nio.file.FileSystem newFileSystem, String scheme, String name, Map<String, ?> env) {
                if (RepositoryServiceImpl.this.getRepository(name) == null) {
                    RepositoryServiceImpl.this.createRepository(scheme, name, env);
                }
            }
        });
    }

    public Repository getRepository(String alias) {
        return this.configuredRepositories.get(alias);
    }

    public Repository getRepository(org.uberfire.java.nio.file.FileSystem fs) {
        if (fs == null) {
            return null;
        }
        FileSystem fsystem = Paths.convert(fs);
        for (Repository repository : this.configuredRepositories.values()) {
            if (!repository.getRoot().getFileSystem().equals(fsystem)) continue;
            return repository;
        }
        if (this.systemRepository.getRoot().getFileSystem().equals(fsystem)) {
            return this.systemRepository;
        }
        return null;
    }

    public Repository getRepository(Path root) {
        return this.rootToRepo.get(root);
    }

    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.configuredRepositories.values());
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, Map<String, Object> env) throws RepositoryAlreadyExistsException {
        Repository repository = this.createRepository(scheme, alias, env);
        if (organizationalUnit != null) {
            this.organizationalUnitService.addRepository(organizationalUnit, repository);
        }
        return repository;
    }

    public Repository createRepository(String scheme, String alias, Map<String, Object> env) {
        if (this.configuredRepositories.containsKey(alias) || SystemRepository.SYSTEM_REPO.getAlias().equals(alias)) {
            throw new RepositoryAlreadyExistsException(alias);
        }
        ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
        if (!env.containsKey("scheme")) {
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
        }
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            if (entry.getKey().startsWith("crypt:")) {
                repositoryConfig.addConfigItem((ConfigItem)this.configurationFactory.newSecuredConfigItem(entry.getKey(), entry.getValue().toString()));
                continue;
            }
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem(entry.getKey(), entry.getValue()));
        }
        Repository repo = this.createRepository(repositoryConfig);
        this.event.fire((Object)new NewRepositoryEvent(repo));
        return repo;
    }

    private Repository createRepository(ConfigGroup repositoryConfig) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.put(repository.getAlias(), repository);
        this.rootToRepo.put(repository.getRoot(), repository);
        return repository;
    }

    public String normalizeRepositoryName(String name) {
        return TextUtil.normalizeRepositoryName(name);
    }

    public void addRole(Repository repository, String role) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem roles = thisRepositoryConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).add(role);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
        this.configuredRepositories.put(updatedRepo.getAlias(), updatedRepo);
        this.rootToRepo.put(updatedRepo.getRoot(), updatedRepo);
    }

    public void removeRole(Repository repository, String role) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem roles = thisRepositoryConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).remove(role);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
        this.configuredRepositories.put(updatedRepo.getAlias(), updatedRepo);
        this.rootToRepo.put(updatedRepo.getRoot(), updatedRepo);
    }

    protected ConfigGroup findRepositoryConfig(String alias) {
        List groups = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(alias)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeRepository(String alias) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(alias);
        if (thisRepositoryConfig != null) {
            this.configurationService.removeConfiguration(thisRepositoryConfig);
            Repository repo = this.configuredRepositories.remove(alias);
            if (repo != null) {
                this.rootToRepo.remove(repo.getRoot());
                this.ioService.delete(Paths.convert(repo.getRoot()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
        }
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        for (OrganizationalUnit ou : organizationalUnits) {
            for (Repository repository : ou.getRepositories()) {
                if (!repository.getAlias().equals(alias)) continue;
                this.organizationalUnitService.removeRepository(ou, repository);
            }
        }
    }

    public RepositoryInfo getRepositoryInfo(String alias) {
        Repository repo = this.getRepository(alias);
        String ouName = null;
        for (OrganizationalUnit ou : this.organizationalUnitService.getOrganizationalUnits()) {
            for (Repository repository : ou.getRepositories()) {
                if (!repository.getAlias().equals(alias)) continue;
                ouName = ou.getName();
            }
        }
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert(repo.getRoot()), VersionAttributeView.class);
        final List records = versionAttributeView.readAttributes().history().records();
        Collections.reverse(records);
        return new RepositoryInfo(alias, ouName, repo.getRoot(), repo.getPublicURIs(), (List)new ArrayList<VersionRecord>(10){
            {
                super(x0);
                int size = 0;
                for (VersionRecord record : records) {
                    this.add(new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
                    if (++size <= 10) continue;
                    break;
                }
            }
        });
    }

    public List<VersionRecord> getRepositoryHistory(String alias, int startIndex) {
        Repository repo = this.getRepository(alias);
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert(repo.getRoot()), VersionAttributeView.class);
        List records = versionAttributeView.readAttributes().history().records();
        if (records.size() <= startIndex) {
            return Collections.emptyList();
        }
        Collections.reverse(records);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(10);
        int size = 0;
        for (VersionRecord record : records.subList(startIndex, records.size() > startIndex + 10 ? startIndex + 10 : records.size())) {
            result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
            if (++size <= 10) continue;
            break;
        }
        return result;
    }

    public void updateRegisteredRepositories(@Observes @org.uberfire.backend.server.config.Repository SystemRepositoryChangedEvent changedEvent) {
        this.configuredRepositories.clear();
        this.loadRepositories();
    }
}

