/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.net.URI;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class FileSystemResourceAdaptorTest {
    @Test
    public void testFileSystemToCheckProxyIssuesWithExtraInterfaces() {
        FileSystem mockedFS = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)mockedFS.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("jgit://myrepo"));
        Mockito.when((Object)((FileSystemId)mockedFSId).id()).thenReturn((Object)"my-fsid");
        FileSystemResourceAdaptor fileSystemResourceAdaptor = new FileSystemResourceAdaptor(mockedFS);
        Assert.assertEquals((Object)mockedFSId, (Object)fileSystemResourceAdaptor.getFileSystem());
        Assert.assertEquals((Object)"my-fsid", (Object)fileSystemResourceAdaptor.getSignatureId());
    }
}

