/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.server.authz.AuthorizationPolicyMarshaller;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

public class AuthzPolicyMarshallerTest {
    AuthorizationPolicyBuilder builder;
    AuthorizationPolicyMarshaller marshaller;
    PermissionManager permissionManager;

    @Before
    public void setUp() {
        this.permissionManager = new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry());
        this.builder = this.permissionManager.newAuthorizationPolicy();
        this.marshaller = new AuthorizationPolicyMarshaller();
    }

    @Test
    public void testHomeEntry() {
        List tokens = this.marshaller.split("role.admin.home");
        Assert.assertEquals((long)tokens.size(), (long)3L);
        Assert.assertEquals(tokens.get(0), (Object)"role");
        Assert.assertEquals(tokens.get(1), (Object)"admin");
        Assert.assertEquals(tokens.get(2), (Object)"home");
    }

    @Test
    public void testPriorityEntry() {
        List tokens = this.marshaller.split("role.admin.priority");
        Assert.assertEquals((long)tokens.size(), (long)3L);
        Assert.assertEquals(tokens.get(0), (Object)"role");
        Assert.assertEquals(tokens.get(1), (Object)"admin");
        Assert.assertEquals(tokens.get(2), (Object)"priority");
    }

    @Test
    public void testPermissionEntry() {
        List tokens = this.marshaller.split("role.admin.permission.perspective.read");
        Assert.assertEquals((long)tokens.size(), (long)4L);
        Assert.assertEquals(tokens.get(0), (Object)"role");
        Assert.assertEquals(tokens.get(1), (Object)"admin");
        Assert.assertEquals(tokens.get(2), (Object)"permission");
        Assert.assertEquals(tokens.get(3), (Object)"perspective.read");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidEntry1() {
        this.marshaller.split("role..priority");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidEntry2() {
        this.marshaller.split(".admin.priority");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidEntry3() {
        this.marshaller.split("role");
    }

    @Test
    public void testPolicyRead() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("WEB-INF/classes/security-policy.properties");
        Path policyPath = Paths.get(fileURL.toURI());
        Properties input = new Properties();
        input.load(Files.newBufferedReader(policyPath));
        this.marshaller.read(this.builder, new Map[]{input});
        AuthorizationPolicy policy = this.builder.build();
        Set roles = policy.getRoles();
        Assert.assertEquals((long)roles.size(), (long)3L);
        RoleImpl adminRole = new RoleImpl("admin");
        PermissionCollection permissions = policy.getPermissions((Role)adminRole);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)adminRole), (Object)"Administrator");
        Assert.assertEquals((long)policy.getPriority((Role)adminRole), (long)1L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        Permission permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        RoleImpl userRole = new RoleImpl("user");
        permissions = policy.getPermissions((Role)userRole);
        Assert.assertTrue((boolean)roles.contains(userRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)userRole), (Object)"End user");
        Assert.assertEquals((long)policy.getPriority((Role)userRole), (long)2L);
        Assert.assertEquals((long)permissions.collection().size(), (long)4L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        permission = permissions.get("perspective.read.HomePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        RoleImpl managerRole = new RoleImpl("manager");
        permissions = policy.getPermissions((Role)managerRole);
        Assert.assertTrue((boolean)roles.contains(managerRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)managerRole), (Object)"Manager");
        Assert.assertEquals((long)policy.getPriority((Role)managerRole), (long)3L);
        Assert.assertEquals((long)permissions.collection().size(), (long)2L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testPolicyWrite() throws Exception {
        this.builder.role("admin").priority(5).home("A").permission("p1", Boolean.valueOf(true)).permission("p2", Boolean.valueOf(false));
        this.builder.group("group1").priority(3).home("B").permission("p1", Boolean.valueOf(false)).permission("p2", Boolean.valueOf(true));
        AuthorizationPolicy policy = this.builder.build();
        TreeMap output = new TreeMap();
        this.marshaller.write(policy, output);
        Assert.assertEquals((long)output.size(), (long)8L);
        Assert.assertEquals(output.get("role.admin.home"), (Object)"A");
        Assert.assertEquals(output.get("role.admin.priority"), (Object)"5");
        Assert.assertEquals(output.get("role.admin.permission.p1"), (Object)"true");
        Assert.assertEquals(output.get("role.admin.permission.p2"), (Object)"false");
        Assert.assertEquals(output.get("group.group1.home"), (Object)"B");
        Assert.assertEquals(output.get("group.group1.priority"), (Object)"3");
        Assert.assertEquals(output.get("group.group1.permission.p1"), (Object)"false");
        Assert.assertEquals(output.get("group.group1.permission.p2"), (Object)"true");
    }
}

