/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.object;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.backend.server.io.object.ObjectStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;

public class ObjectStorageTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private IOService ioService;
    private FileSystem fileSystem;
    private SessionInfo sessionInfo;
    private ObjectStorageImpl objectStorage;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        this.sessionInfo = this.mockSessionInfo();
        this.fileSystem = this.mockFileSystem();
        this.ioService = this.mockIoService(this.fileSystem);
        this.objectStorage = new ObjectStorageImpl(this.ioService);
        this.objectStorage.init("default://object/store");
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void testForAFileDoesNotExist() {
        String file = "my.object.file";
        boolean objectExists = this.objectStorage.exists("/forks/my.object.file");
        Assert.assertFalse((boolean)objectExists);
    }

    @Test
    public void testWriteFileAndCheckThatExists() {
        this.objectStorage.write("/forks/uberfire.txt", (Object)"content");
        boolean exists = this.objectStorage.exists("/forks/uberfire.txt");
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testWriteAndRead() {
        String fileContent = "content";
        this.objectStorage.write("/forks/uberfire", (Object)"content");
        String content = (String)this.objectStorage.read("/forks/uberfire");
        Assert.assertEquals((Object)"content", (Object)content);
    }

    @Test
    public void testWriteAndReadList() {
        ArrayList<String> fileContent = new ArrayList<String>();
        fileContent.add("uberfire");
        this.objectStorage.write("/forks/uberfire", fileContent);
        List content = (List)this.objectStorage.read("/forks/uberfire");
        Assert.assertEquals((long)fileContent.size(), (long)content.size());
        Assert.assertEquals(fileContent.get(0), content.get(0));
    }

    @Test
    public void testWithDoubleSlashPath() {
        String fileContent = "content";
        this.objectStorage.write("/forks/uberfire", (Object)"content");
        String content = (String)this.objectStorage.read("/forks/uberfire");
        Assert.assertEquals((Object)"content", (Object)content);
    }

    @Test
    public void testWriteTwoTimes() {
        this.objectStorage.write("/forks/uberfire", (Object)"content a");
        this.objectStorage.write("/forks/uberfire", (Object)"content b");
        String content = (String)this.objectStorage.read("/forks/uberfire");
        Assert.assertEquals((Object)"content b", (Object)content);
    }

    @Test
    public void testWriteAndDelete() {
        this.objectStorage.write("/forks/uberfire", (Object)"content b");
        Assert.assertTrue((boolean)this.objectStorage.exists("/forks/uberfire"));
        this.objectStorage.delete("/forks/uberfire");
        Assert.assertFalse((boolean)this.objectStorage.exists("/forks/uberfire"));
    }

    private SessionInfo mockSessionInfo() {
        return new SessionInfoMock();
    }

    private FileSystem mockFileSystem() {
        return fileSystemTestingUtils.getFileSystem();
    }

    private IOService mockIoService(FileSystem fileSystem) {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)fileSystem).when((Object)ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        return ioService;
    }

    static {
        System.setProperty("errai.devel.nocache", "true");
        System.out.println("Working Dir: " + new File("").getAbsoluteFile().getAbsolutePath());
    }
}

