/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.nio.file.Paths;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugin.AbstractGwtRuntimePluginTest;
import org.uberfire.backend.server.plugin.GwtRuntimePluginLoader;
import org.uberfire.backend.server.plugin.PluginRegistry;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;
import org.uberfire.workbench.events.PluginsReloadedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GwtRuntimePluginLoaderTest
extends AbstractGwtRuntimePluginTest {
    private GwtRuntimePluginLoader pluginLoader;
    @Mock
    private Event<PluginAddedEvent> pluginAddedEvent;
    @Mock
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;
    @Mock
    private Event<PluginsReloadedEvent> pluginsReloadedEvent;
    @Mock
    private PluginRegistry pluginRegistry;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.pluginLoader = (GwtRuntimePluginLoader)Mockito.spy((Object)new GwtRuntimePluginLoader(this.pluginAddedEvent, this.pluginUpdatedEvent, this.pluginsReloadedEvent));
    }

    @Test
    public void initLoadsDeployedPlugins() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        ((GwtRuntimePluginLoader)Mockito.verify((Object)this.pluginLoader)).loadPlugins();
    }

    @Test
    public void reloadClearsPluginRegistry() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        this.pluginLoader.reload();
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry, (VerificationMode)Mockito.times((int)2))).removeAll();
    }

    @Test
    public void reloadFiresPluginsReloadedEvent() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        this.pluginLoader.reload();
        ((Event)Mockito.verify(this.pluginsReloadedEvent)).fire(Matchers.any(PluginsReloadedEvent.class));
    }

    @Test
    public void loadPluginRegistersScript() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        ((GwtRuntimePluginLoader)Mockito.doReturn((Object)"test.nocache.js").when((Object)this.pluginLoader)).processPluginJar((String)Matchers.any(String.class));
        ArgumentCaptor url = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor name = ArgumentCaptor.forClass(String.class);
        this.pluginLoader.loadPlugin(Paths.get("test", new String[0]), false);
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry)).isRegistered("test.nocache.js");
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry)).add((String)name.capture(), (String)url.capture());
        Assert.assertEquals((Object)"test.nocache.js", (Object)name.getValue());
        Assert.assertNotNull((Object)url.getValue());
        Assert.assertTrue((boolean)((String)url.getValue()).startsWith("test-app/test.nocache.js?nocache="));
    }

    @Test
    public void loadPluginFiresPluginAddedEvent() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        ((GwtRuntimePluginLoader)Mockito.doReturn((Object)"test.nocache.js").when((Object)this.pluginLoader)).processPluginJar((String)Matchers.any(String.class));
        this.pluginLoader.loadPlugin(Paths.get("test", new String[0]), true);
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry)).isRegistered("test.nocache.js");
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry)).add((String)Matchers.any(String.class), (String)Matchers.any(String.class));
        ((Event)Mockito.verify(this.pluginAddedEvent)).fire(Matchers.any(PluginAddedEvent.class));
    }

    @Test
    public void loadPluginFiresPluginUpdatedEvent() throws Exception {
        this.pluginLoader.init(this.contextRootDir, this.pluginDir, this.pluginDeploymentDir, this.pluginRegistry);
        ((GwtRuntimePluginLoader)Mockito.doReturn((Object)"test.nocache.js").when((Object)this.pluginLoader)).processPluginJar((String)Matchers.any(String.class));
        Mockito.when((Object)this.pluginRegistry.isRegistered("test.nocache.js")).thenReturn((Object)true);
        this.pluginLoader.loadPlugin(Paths.get("test", new String[0]), true);
        ((PluginRegistry)Mockito.verify((Object)this.pluginRegistry)).isRegistered("test.nocache.js");
        ((Event)Mockito.verify(this.pluginUpdatedEvent)).fire(Matchers.any(PluginUpdatedEvent.class));
    }
}

