/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.plugin.PluginProcessor;
import org.uberfire.backend.server.plugins.engine.AbstractPluginsTest;
import org.uberfire.backend.server.plugins.engine.PluginJarProcessor;
import org.uberfire.backend.server.plugins.processors.GWTScriptPluginProcessor;
import org.uberfire.backend.server.plugins.processors.HTMLPluginProcessor;
import org.uberfire.backend.server.plugins.processors.UFJSPluginProcessor;
import org.uberfire.workbench.events.PluginReloadedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginJarProcessorTest
extends AbstractPluginsTest {
    @Mock
    Instance<PluginProcessor> pluginProcessors;
    @Mock
    private Event<PluginReloadedEvent> pluginsReloadedEvent;
    @Mock
    private GWTScriptPluginProcessor gwtScriptPluginProcessor;
    @Mock
    private HTMLPluginProcessor htmlPluginProcessor;
    @Mock
    private UFJSPluginProcessor ufjsPluginProcessor;
    PluginJarProcessor pluginJarProcessor;

    @Override
    @Before
    public void setup() {
        super.setup();
        List<PluginProcessor> pluginProcessorsList = Arrays.asList(this.gwtScriptPluginProcessor, this.htmlPluginProcessor, this.ufjsPluginProcessor);
        Mockito.when((Object)this.pluginProcessors.iterator()).thenReturn(pluginProcessorsList.iterator());
        this.pluginJarProcessor = (PluginJarProcessor)Mockito.spy((Object)new PluginJarProcessor(this.pluginProcessors, this.pluginsReloadedEvent){

            List<String> extractFilesFromPluginsJar(String jarFileName) {
                return Arrays.asList("dora.html", "dora.txt");
            }
        });
    }

    @Test
    public void initLoadsDeployedPlugins() throws Exception {
        this.pluginJarProcessor.init(this.pluginDir, this.pluginDeploymentDir);
        ((PluginJarProcessor)Mockito.verify((Object)this.pluginJarProcessor)).loadPlugins();
    }

    @Test
    public void reloadClearsPluginRegistry() throws Exception {
        this.pluginJarProcessor.init(this.pluginDir, this.pluginDeploymentDir);
        this.pluginJarProcessor.reload();
        ((PluginJarProcessor)Mockito.verify((Object)this.pluginJarProcessor, (VerificationMode)Mockito.times((int)2))).removeAllPlugins();
    }

    @Test
    public void reloadFiresPluginsReloadedEvent() throws Exception {
        this.pluginJarProcessor.init(this.pluginDir, this.pluginDeploymentDir);
        this.pluginJarProcessor.reload();
        ((Event)Mockito.verify(this.pluginsReloadedEvent)).fire(Mockito.any(PluginReloadedEvent.class));
    }

    @Test
    public void loadPlugins() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toFile()).thenReturn(Mockito.mock(File.class));
        Mockito.when((Object)this.htmlPluginProcessor.shouldProcess("dora.html")).thenReturn((Object)true);
        this.pluginJarProcessor.loadPlugins(path, true);
        ((HTMLPluginProcessor)Mockito.verify((Object)this.htmlPluginProcessor, (VerificationMode)Mockito.times((int)1))).process((String)Mockito.eq((Object)"dora.html"), (String)Mockito.any(), Mockito.eq((boolean)true));
    }
}

