/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.server.WebAppSettings;
import org.uberfire.backend.server.authz.AuthorizationPolicyDeployer;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthzPolicyDeployerTest {
    @Mock
    AuthorizationPolicyStorage storage;
    @Mock
    Event<AuthorizationPolicyDeployedEvent> event;
    AuthorizationPolicyDeployer deployer;
    PermissionManager permissionManager;

    @Before
    public void setUp() {
        DefaultPermissionTypeRegistry permissionTypeRegistry = new DefaultPermissionTypeRegistry();
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager((PermissionTypeRegistry)permissionTypeRegistry));
        this.deployer = new AuthorizationPolicyDeployer(this.storage, this.permissionManager, this.event);
        RoleRegistry.get().clear();
    }

    @Test
    public void testPolicyDir() throws Exception {
        WebAppSettings.get().setRootDir("/test");
        Path path = this.deployer.getPolicyDir();
        Path expected = Paths.get(URI.create("file:///test/WEB-INF/classes"));
        Assert.assertEquals((Object)path, (Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPolicy() throws Exception {
        this.testPolicyLoad("WEB-INF/classes/invalid/security-policy.properties");
    }

    @Test
    public void testPolicyLoad() throws Exception {
        this.testPolicyLoad("WEB-INF/classes/security-policy.properties");
    }

    @Test
    public void testPolicyLoad2() throws Exception {
        this.testPolicyLoad("WEB-INF/classes/split/security-policy.properties");
    }

    public void testPolicyLoad(String path) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(path);
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        Assert.assertTrue((boolean)RoleRegistry.get().getRegisteredRoles().isEmpty());
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        ((Event)Mockito.verify(this.event)).fire(Mockito.any());
        AuthorizationPolicy policy = (AuthorizationPolicy)policyCaptor.getValue();
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).setAuthorizationPolicy(policy);
        Assert.assertEquals((long)RoleRegistry.get().getRegisteredRoles().size(), (long)3L);
        Set roles = policy.getRoles();
        Assert.assertEquals((long)roles.size(), (long)3L);
        RoleImpl adminRole = new RoleImpl("admin");
        PermissionCollection permissions = policy.getPermissions((Role)adminRole);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)adminRole), (Object)"Administrator");
        Assert.assertEquals((long)policy.getPriority((Role)adminRole), (long)1L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        Permission permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        RoleImpl userRole = new RoleImpl("user");
        permissions = policy.getPermissions((Role)userRole);
        Assert.assertTrue((boolean)roles.contains(userRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)userRole), (Object)"End user");
        Assert.assertEquals((long)policy.getPriority((Role)userRole), (long)2L);
        Assert.assertEquals((long)permissions.collection().size(), (long)4L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        permission = permissions.get("perspective.read.HomePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        RoleImpl managerRole = new RoleImpl("manager");
        permissions = policy.getPermissions((Role)managerRole);
        Assert.assertTrue((boolean)roles.contains(managerRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)managerRole), (Object)"Manager");
        Assert.assertEquals((long)policy.getPriority((Role)managerRole), (long)3L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("repository.read.git://repo1");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testNothingToDeploy() throws Exception {
        this.deployer.deployPolicy(null);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).savePolicy((AuthorizationPolicy)Mockito.any());
    }

    @Test
    public void testAlreadyDeployed() throws Exception {
        Mockito.when((Object)this.storage.loadPolicy()).thenReturn(Mockito.mock(AuthorizationPolicy.class));
        this.deployer.deployPolicy(Paths.get("", new String[0]));
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).savePolicy((AuthorizationPolicy)Mockito.any());
    }
}

