/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.backend.server.io.DisposableShutdownService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PriorityDisposableRegistry.class, FileSystemProviders.class})
public class DisposableShutdownServiceTest {
    private ExecutorService executorService;
    private ExecutorService unmanagedExecutorService;
    private DisposableShutdownService disposableShutdownService;

    @Before
    public void setUp() {
        this.executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        this.unmanagedExecutorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        this.disposableShutdownService = new DisposableShutdownService(this.executorService, this.unmanagedExecutorService);
        PowerMockito.mockStatic(PriorityDisposableRegistry.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(FileSystemProviders.class, (Class[])new Class[0]);
    }

    @Test
    public void testGeneralStatic() {
        JGitFileSystemProvider disposableProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)FileSystemProviders.installedProviders()).thenReturn(Arrays.asList((FileSystemProvider)Mockito.mock(FileSystemProvider.class), disposableProvider));
        this.disposableShutdownService.contextDestroyed(null);
        ((JGitFileSystemProvider)Mockito.verify((Object)disposableProvider, (VerificationMode)Mockito.times((int)1))).dispose();
        ((ExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).shutdown();
        ((ExecutorService)Mockito.verify((Object)this.unmanagedExecutorService, (VerificationMode)Mockito.times((int)1))).shutdown();
        PowerMockito.verifyStatic();
        PriorityDisposableRegistry.clear();
    }

    @Test
    public void testCluster() {
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        Mockito.when((Object)FileSystemProviders.installedProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)PriorityDisposableRegistry.getDisposables()).thenReturn(Arrays.asList((PriorityDisposable)Mockito.mock(PriorityDisposable.class), clusterService));
        this.disposableShutdownService.contextDestroyed(null);
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)1))).lock();
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)1))).unlock();
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)1))).dispose();
    }

    @Test
    public void testDisposables() {
        PriorityDisposable priorityDisposable1 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        PriorityDisposable priorityDisposable2 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        PriorityDisposable priorityDisposable3 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        Mockito.when((Object)FileSystemProviders.installedProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)PriorityDisposableRegistry.getDisposables()).thenReturn(Arrays.asList(priorityDisposable1, priorityDisposable2, priorityDisposable3));
        this.disposableShutdownService.contextDestroyed(null);
        ((PriorityDisposable)Mockito.verify((Object)priorityDisposable1, (VerificationMode)Mockito.times((int)1))).dispose();
        ((PriorityDisposable)Mockito.verify((Object)priorityDisposable2, (VerificationMode)Mockito.times((int)1))).dispose();
        ((PriorityDisposable)Mockito.verify((Object)priorityDisposable3, (VerificationMode)Mockito.times((int)1))).dispose();
    }

    @Test
    public void testSort() {
        PriorityDisposable priorityDisposable1 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        Mockito.when((Object)priorityDisposable1.priority()).thenReturn((Object)-1);
        PriorityDisposable priorityDisposable2 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        Mockito.when((Object)priorityDisposable2.priority()).thenReturn((Object)0);
        PriorityDisposable priorityDisposable3 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        Mockito.when((Object)priorityDisposable3.priority()).thenReturn((Object)10);
        PriorityDisposable priorityDisposable4 = (PriorityDisposable)Mockito.mock(PriorityDisposable.class);
        Mockito.when((Object)priorityDisposable4.priority()).thenReturn((Object)11);
        ArrayList<PriorityDisposable> disposables = new ArrayList<PriorityDisposable>();
        disposables.add(priorityDisposable3);
        disposables.add(priorityDisposable2);
        disposables.add(priorityDisposable4);
        disposables.add(priorityDisposable1);
        Assert.assertEquals((Object)priorityDisposable3, disposables.get(0));
        Assert.assertEquals((Object)priorityDisposable2, disposables.get(1));
        Assert.assertEquals((Object)priorityDisposable4, disposables.get(2));
        Assert.assertEquals((Object)priorityDisposable1, disposables.get(3));
        this.disposableShutdownService.sort(disposables);
        Assert.assertEquals((long)4L, (long)disposables.size());
        Assert.assertEquals((Object)priorityDisposable4, disposables.get(0));
        Assert.assertEquals((Object)priorityDisposable3, disposables.get(1));
        Assert.assertEquals((Object)priorityDisposable2, disposables.get(2));
        Assert.assertEquals((Object)priorityDisposable1, disposables.get(3));
    }
}

