/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugins.engine.AbstractPluginsTest;
import org.uberfire.backend.server.plugins.engine.PluginJarProcessor;
import org.uberfire.backend.server.plugins.engine.PluginManager;
import org.uberfire.backend.server.plugins.engine.PluginWatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginManagerTest
extends AbstractPluginsTest {
    @Mock
    private PluginWatcher pluginWatcher;
    @Mock
    private PluginJarProcessor pluginJarProcessor;
    @InjectMocks
    private PluginManager manager;

    @Test
    public void initPluginLoader() throws Exception {
        this.manager.init(this.contextRootDir, this.pluginDir);
        ((PluginJarProcessor)Mockito.verify((Object)this.pluginJarProcessor, (VerificationMode)Mockito.times((int)1))).init((String)Matchers.eq((Object)this.pluginDir), (String)Matchers.eq((Object)this.pluginDeploymentDir));
    }

    @Test
    public void initStartsWatcher() throws Exception {
        this.manager.init(this.contextRootDir, this.pluginDir);
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).start((String)Matchers.eq((Object)this.pluginDir), (ExecutorService)Matchers.any(ExecutorService.class), (PluginJarProcessor)Matchers.eq((Object)this.pluginJarProcessor));
    }

    @Test
    public void shutdownStopsWatcher() throws Exception {
        this.manager.shutDown();
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void findPluginDeploymentDir() throws Exception {
        PluginManager managerSpy = (PluginManager)Mockito.spy((Object)this.manager);
        String pluginDeploymentDir = managerSpy.findPluginDeploymentDir(this.contextRootDir);
        ((PluginManager)Mockito.verify((Object)managerSpy)).encodePath(this.contextRootDir);
        Assert.assertEquals((Object)this.pluginDeploymentDir, (Object)pluginDeploymentDir);
    }
}

