/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Collections;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.LockCleanupSessionListener;
import org.uberfire.backend.server.io.ConfigIOServiceProducer;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class LockCleanupSessionListenerTest {
    @Mock
    private HttpSessionEvent evt;
    @Mock
    private HttpSession session;
    @Mock
    private IOService ioService;

    @Test
    public void throwExceptionWhenIOProducerNotInitialized() {
        LockCleanupSessionListener listener = new LockCleanupSessionListener();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> listener.sessionDestroyed(this.evt)).isInstanceOf(IllegalStateException.class)).hasMessage("org.uberfire.backend.server.io.ConfigIOServiceProducer not initialized on startup");
    }

    @Test
    public void initWithoutInjection() {
        ConfigIOServiceProducer producer = (ConfigIOServiceProducer)Mockito.spy((Object)new ConfigIOServiceProducer());
        LockCleanupSessionListener listener = new LockCleanupSessionListener();
        try {
            Mockito.when((Object)this.evt.getSession()).thenReturn((Object)this.session);
            Mockito.when((Object)this.session.getAttribute("uf-locks")).thenReturn(Collections.emptySet());
            Mockito.when((Object)producer.configIOService()).thenReturn((Object)this.ioService);
            producer.setup();
            listener.sessionDestroyed(this.evt);
            ((ConfigIOServiceProducer)Mockito.verify((Object)producer)).configIOService();
            ((ConfigIOServiceProducer)Mockito.verify((Object)producer)).configFileSystem();
        }
        finally {
            producer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void releaseLockAssociatedWithSession() {
        ConfigIOServiceProducer producer = (ConfigIOServiceProducer)Mockito.spy((Object)new ConfigIOServiceProducer());
        LockCleanupSessionListener listener = (LockCleanupSessionListener)Mockito.spy((Object)new LockCleanupSessionListener());
        try {
            String lockedBy = "christian";
            LockInfo lock = new LockInfo(true, "christian", PathFactory.newPath((String)"file", (String)"default://file"));
            Mockito.when((Object)this.evt.getSession()).thenReturn((Object)this.session);
            Mockito.when((Object)this.session.getAttribute("uf-locks")).thenReturn(Collections.singleton(lock));
            Mockito.when((Object)producer.configIOService()).thenReturn((Object)this.ioService);
            Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"christian");
            producer.setup();
            listener.sessionDestroyed(this.evt);
            ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).delete((Path)Mockito.any(Path.class), new DeleteOption[0]);
        }
        finally {
            producer.destroy();
        }
    }
}

