/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.enterprise.event.Event;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.server.WebAppSettings;
import org.uberfire.backend.server.authz.AuthorizationPolicyDeployer;
import org.uberfire.backend.server.authz.AuthorizationPolicyVfsStorage;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthzPolicyDeployerTest {
    @Mock
    protected SpacesAPI spaces;
    @Mock
    AuthorizationPolicyStorage storage;
    AuthorizationPolicyVfsStorage vfsstorage;
    private FileSystem fileSystem;
    @Mock
    Event<AuthorizationPolicyDeployedEvent> event;
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    AuthorizationPolicyDeployer deployer;
    PermissionManager permissionManager;
    IOService ioService;

    @Before
    public void setUp() throws IOException {
        fileSystemTestingUtils.setup();
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Mockito.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)this.fileSystem).when((Object)this.ioService)).newFileSystem((URI)Mockito.any(URI.class), Matchers.anyMap());
        DefaultPermissionTypeRegistry permissionTypeRegistry = new DefaultPermissionTypeRegistry();
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager((PermissionTypeRegistry)permissionTypeRegistry));
        this.vfsstorage = new AuthorizationPolicyVfsStorage(this.ioService, this.permissionManager, this.spaces);
        this.deployer = new AuthorizationPolicyDeployer(this.storage, this.permissionManager, this.event);
        this.vfsstorage.initFileSystem();
        RoleRegistry.get().clear();
    }

    @Test
    public void testPolicyDir() {
        WebAppSettings.get().setRootDir("/test");
        Path path = this.deployer.getPolicyDir();
        Path expected = Paths.get(URI.create("file:///test/WEB-INF/classes"));
        Assert.assertEquals((Object)path, (Object)expected);
    }

    @Test
    public void testInvalidPolicy() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testPolicyLoad("WEB-INF/classes/invalid/security-policy.properties")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Key must start with [default|role|group]");
    }

    @Test
    public void testPolicyLoad() throws Exception {
        this.testPolicyLoad("WEB-INF/classes/security-policy.properties");
    }

    @Test
    public void testPolicyLoad2() throws Exception {
        this.testPolicyLoad("WEB-INF/classes/split/security-policy.properties");
    }

    @Test
    public void testPolicyDelete() throws Exception {
        this.testPolicyDelete("WEB-INF/classes/security-policy.properties");
    }

    public void testPolicyDelete(String path) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(path);
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        Assert.assertTrue((boolean)RoleRegistry.get().getRegisteredRoles().isEmpty());
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        this.vfsstorage.savePolicy((AuthorizationPolicy)policyCaptor.getValue());
        AuthorizationPolicy policy = this.vfsstorage.loadPolicyFromVfs();
        Set groups = policy.getGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
        GroupImpl group = new GroupImpl("group1");
        PermissionCollection permissions = policy.getPermissions((Group)group);
        Permission permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_GRANTED, (Object)permission.getResult());
        this.vfsstorage.deletePolicyByGroup((Group)group, (AuthorizationPolicy)policyCaptor.getValue());
        ((Event)Mockito.verify(this.event)).fire(Mockito.any());
        policy = this.vfsstorage.loadPolicyFromVfs();
        groups = policy.getGroups();
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    public void testPolicyLoad(String path) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(path);
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        Assert.assertTrue((boolean)RoleRegistry.get().getRegisteredRoles().isEmpty());
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        ((Event)Mockito.verify(this.event)).fire(Mockito.any());
        AuthorizationPolicy policy = (AuthorizationPolicy)policyCaptor.getValue();
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).setAuthorizationPolicy(policy);
        Assert.assertEquals((long)RoleRegistry.get().getRegisteredRoles().size(), (long)3L);
        Set roles = policy.getRoles();
        Assert.assertEquals((long)roles.size(), (long)3L);
        RoleImpl adminRole = new RoleImpl("admin");
        PermissionCollection permissions = policy.getPermissions((Role)adminRole);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)adminRole), (Object)"Administrator");
        Assert.assertEquals((long)policy.getPriority((Role)adminRole), (long)1L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        Permission permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        RoleImpl userRole = new RoleImpl("user");
        permissions = policy.getPermissions((Role)userRole);
        Assert.assertTrue((boolean)roles.contains(userRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)userRole), (Object)"End user");
        Assert.assertEquals((long)policy.getPriority((Role)userRole), (long)2L);
        Assert.assertEquals((long)permissions.collection().size(), (long)4L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        permission = permissions.get("perspective.read.HomePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        RoleImpl managerRole = new RoleImpl("manager");
        permissions = policy.getPermissions((Role)managerRole);
        Assert.assertTrue((boolean)roles.contains(managerRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)managerRole), (Object)"Manager");
        Assert.assertEquals((long)policy.getPriority((Role)managerRole), (long)3L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("repository.read.git://repo1");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testNothingToDeploy() {
        this.deployer.deployPolicy(null);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).savePolicy((AuthorizationPolicy)Mockito.any());
    }

    @Test
    public void testAlreadyDeployed() {
        Mockito.when((Object)this.storage.loadPolicy()).thenReturn(Mockito.mock(AuthorizationPolicy.class));
        this.deployer.deployPolicy(Paths.get("", new String[0]));
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).savePolicy((AuthorizationPolicy)Mockito.any());
    }
}

