/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.authz.AuthorizationPolicyMarshaller;
import org.uberfire.backend.server.authz.NonEscapedProperties;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

public class AuthzPolicyMarshallerTest {
    AuthorizationPolicyBuilder builder;
    AuthorizationPolicyMarshaller marshaller;
    PermissionManager permissionManager;

    @Before
    public void setUp() {
        this.permissionManager = new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry());
        this.builder = this.permissionManager.newAuthorizationPolicy();
        this.marshaller = new AuthorizationPolicyMarshaller();
    }

    protected User createUserMock(String ... roles) {
        User user = (User)Mockito.mock(User.class);
        Set roleSet = Stream.of(roles).map(RoleImpl::new).collect(Collectors.toSet());
        Mockito.when((Object)user.getRoles()).thenReturn(roleSet);
        Mockito.when((Object)user.getGroups()).thenReturn(null);
        return user;
    }

    @Test
    public void testDefaultHomeEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("default.home");
        Assert.assertTrue((boolean)key.isDefault());
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"home");
    }

    @Test
    public void testDefaultPermissionEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("default.permission.perspective.read");
        Assert.assertTrue((boolean)key.isDefault());
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"permission");
        Assert.assertEquals((Object)key.getAttributeId(), (Object)"perspective.read");
    }

    @Test
    public void testOverwriteDefault() {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("default.permission.perspective.read", "false");
        input.put("default.permission.perspective.read.HomePerspective", "true");
        input.put("role.user.permission.perspective.read", "false");
        input.put("role.user.permission.perspective.read.HomePerspective", "true");
        input.put("role.user.permission.perspective.read.Sales dashboard", "true");
        this.marshaller.read(this.builder, new Map[]{input});
        this.permissionManager.setAuthorizationPolicy(this.builder.build());
        User user = this.createUserMock("user", "manager");
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        Assert.assertEquals((long)pc.collection().size(), (long)3L);
        Assert.assertEquals((Object)pc.get("perspective.read").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)pc.get("perspective.read.HomePerspective").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)pc.get("perspective.read.Sales dashboard").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testDefaultPermissionsNotOverwrite() {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("default.permission.perspective.read.p1", "false");
        input.put("default.permission.perspective.read.p2", "false");
        input.put("role.user.permission.perspective.read", "true");
        input.put("role.user.permission.perspective.read.p2", "false");
        this.marshaller.read(this.builder, new Map[]{input});
        this.permissionManager.setAuthorizationPolicy(this.builder.build());
        User user = this.createUserMock("user");
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        Assert.assertEquals((long)pc.collection().size(), (long)2L);
        Assert.assertEquals((Object)pc.get("perspective.read").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertNull((Object)pc.get("perspective.read.p1"));
        Assert.assertEquals((Object)pc.get("perspective.read.p2").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testHomeEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("role.admin.home");
        Assert.assertTrue((boolean)key.isRole());
        Assert.assertEquals((Object)key.getRole(), (Object)"admin");
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"home");
        Assert.assertNull((Object)key.getAttributeId());
    }

    @Test
    public void testGroupEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("group.IT.home");
        Assert.assertFalse((boolean)key.isRole());
        Assert.assertTrue((boolean)key.isGroup());
        Assert.assertEquals((Object)key.getGroup(), (Object)"IT");
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"home");
        Assert.assertNull((Object)key.getAttributeId());
    }

    @Test
    public void testPriorityEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("role.admin.priority");
        Assert.assertTrue((boolean)key.isRole());
        Assert.assertEquals((Object)key.getRole(), (Object)"admin");
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"priority");
        Assert.assertNull((Object)key.getAttributeId());
    }

    @Test
    public void testPermissionEntry() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("role.admin.permission.perspective.read");
        Assert.assertTrue((boolean)key.isRole());
        Assert.assertEquals((Object)key.getRole(), (Object)"admin");
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"permission");
        Assert.assertEquals((Object)key.getAttributeId(), (Object)"perspective.read");
    }

    @Test
    public void testSpecialCharsAllowed() {
        AuthorizationPolicyMarshaller.Key key = this.marshaller.parse("role.manager.permission.repository.update.git://repo1");
        Assert.assertTrue((boolean)key.isRole());
        Assert.assertEquals((Object)key.getRole(), (Object)"manager");
        Assert.assertEquals((Object)key.getAttributeType(), (Object)"permission");
        Assert.assertEquals((Object)key.getAttributeId(), (Object)"repository.update.git://repo1");
    }

    @Test
    public void testRoleMissing() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.marshaller.parse("role..priority")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Role value is empty");
    }

    @Test
    public void testTypeMissing() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.marshaller.parse(".admin.priority")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Key must start with [default|role|group]");
    }

    @Test
    public void testIncompleteEntry() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.marshaller.parse("role")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Role value is empty");
    }

    @Test
    public void testReadDefaultEntries() {
        AuthorizationPolicy policy = this.builder.bydefault().home("B").permission("p1", Boolean.valueOf(false)).permission("p2", Boolean.valueOf(true)).role("admin").permission("p1", Boolean.valueOf(true)).build();
        String home = policy.getHomePerspective();
        PermissionCollection pc = policy.getPermissions();
        Assert.assertEquals((Object)home, (Object)"B");
        Assert.assertEquals((long)pc.collection().size(), (long)2L);
        Assert.assertNotNull((Object)pc.get("p1"));
        Assert.assertNotNull((Object)pc.get("p2"));
        Assert.assertEquals((Object)pc.get("p1").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)pc.get("p2").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        RoleImpl admin = new RoleImpl("admin");
        home = policy.getHomePerspective((Role)admin);
        pc = policy.getPermissions((Role)admin);
        Assert.assertEquals((Object)home, (Object)"B");
        Assert.assertEquals((long)pc.collection().size(), (long)2L);
        Assert.assertNotNull((Object)pc.get("p1"));
        Assert.assertNotNull((Object)pc.get("p2"));
        Assert.assertEquals((Object)pc.get("p1").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)pc.get("p2").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testPolicyRead() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("WEB-INF/classes/security-policy.properties");
        Path policyPath = Paths.get(fileURL.toURI());
        NonEscapedProperties input = new NonEscapedProperties();
        input.load((Reader)Files.newBufferedReader(policyPath));
        this.marshaller.read(this.builder, new Map[]{input});
        AuthorizationPolicy policy = this.builder.build();
        Set roles = policy.getRoles();
        Assert.assertEquals((long)roles.size(), (long)3L);
        RoleImpl adminRole = new RoleImpl("admin");
        PermissionCollection permissions = policy.getPermissions((Role)adminRole);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)adminRole), (Object)"Administrator");
        Assert.assertEquals((long)policy.getPriority((Role)adminRole), (long)1L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        Permission permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        RoleImpl userRole = new RoleImpl("user");
        permissions = policy.getPermissions((Role)userRole);
        Assert.assertTrue((boolean)roles.contains(userRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)userRole), (Object)"End user");
        Assert.assertEquals((long)policy.getPriority((Role)userRole), (long)2L);
        Assert.assertEquals((long)permissions.collection().size(), (long)4L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        permission = permissions.get("perspective.read.HomePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("perspective.read.SimplePerspective");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        RoleImpl managerRole = new RoleImpl("manager");
        permissions = policy.getPermissions((Role)managerRole);
        Assert.assertTrue((boolean)roles.contains(managerRole));
        Assert.assertEquals((Object)policy.getRoleDescription((Role)managerRole), (Object)"Manager");
        Assert.assertEquals((long)policy.getPriority((Role)managerRole), (long)3L);
        Assert.assertEquals((long)permissions.collection().size(), (long)3L);
        permission = permissions.get("perspective.read");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        permission = permissions.get("repository.read.git://repo1");
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)permission.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testPolicyWrite() {
        this.builder.role("admin").priority(5).home("A").permission("p1", Boolean.valueOf(true)).permission("p2", Boolean.valueOf(false)).group("group1").priority(3).home("B").permission("p1", Boolean.valueOf(false)).permission("p2", Boolean.valueOf(true)).bydefault().home("B").permission("p1", Boolean.valueOf(false)).permission("p2", Boolean.valueOf(true));
        AuthorizationPolicy policy = this.builder.build();
        TreeMap output = new TreeMap();
        this.marshaller.write(policy, output);
        Assert.assertEquals((long)output.size(), (long)11L);
        Assert.assertEquals(output.get("role.admin.home"), (Object)"A");
        Assert.assertEquals(output.get("role.admin.home"), (Object)"A");
        Assert.assertEquals(output.get("role.admin.priority"), (Object)"5");
        Assert.assertEquals(output.get("role.admin.permission.p1"), (Object)"true");
        Assert.assertEquals(output.get("role.admin.permission.p2"), (Object)"false");
        Assert.assertEquals(output.get("group.group1.home"), (Object)"B");
        Assert.assertEquals(output.get("group.group1.priority"), (Object)"3");
        Assert.assertEquals(output.get("group.group1.permission.p1"), (Object)"false");
        Assert.assertEquals(output.get("group.group1.permission.p2"), (Object)"true");
        Assert.assertEquals(output.get("default.home"), (Object)"B");
        Assert.assertEquals(output.get("default.permission.p1"), (Object)"false");
        Assert.assertEquals(output.get("default.permission.p2"), (Object)"true");
    }

    @Test
    public void testPolicyRemove() {
        this.builder.group("group2").priority(3).home("B").permission("p1", Boolean.valueOf(false)).permission("p2", Boolean.valueOf(true));
        AuthorizationPolicy policy = this.builder.build();
        TreeMap output = new TreeMap();
        this.marshaller.write(policy, output);
        GroupImpl g = new GroupImpl("group2");
        Assert.assertEquals((Object)"B", output.get("group.group2.home"));
        Assert.assertEquals((Object)"3", output.get("group.group2.priority"));
        Assert.assertEquals((Object)"false", output.get("group.group2.permission.p1"));
        Assert.assertEquals((Object)"true", output.get("group.group2.permission.p2"));
        this.marshaller.remove((Group)g, policy, output);
        Assert.assertEquals(null, output.get("group.group2.home"));
        Assert.assertEquals(null, output.get("group.group2.priority"));
        Assert.assertEquals(null, output.get("group.group2.permission.p1"));
        Assert.assertEquals(null, output.get("group.group2.permission.p2"));
    }
}

