/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtil {
    private static final String EMPTY_STRING = "";
    private static final Pattern nonASCIIp1 = Pattern.compile("[^\\p{L}\\p{Nd}]");
    private static final Matcher nonASCIIm1 = nonASCIIp1.matcher("");
    private static final Pattern nonASCIIp2 = Pattern.compile("[^\\x00-\\x7f]");
    private static final Matcher nonASCIIm2 = nonASCIIp2.matcher("");
    private static final Pattern repoP1 = Pattern.compile("[^\\p{L}\\p{Nd}\\x2D\\x2E]");
    private static final Pattern repoP2 = Pattern.compile("[^\\x00-\\x7f\\x2D\\x2E]");
    private static final Pattern repoP3 = Pattern.compile("[\\x2D\\x2E][\\x2D\\x2E]{1,}+");

    public static String normalizeRepositoryName(String input) {
        if (input.startsWith(".") || input.startsWith("-")) {
            input = TextUtil.normalizeRepositoryName(input.substring(1));
        }
        if (input.endsWith(".") || input.endsWith("-")) {
            input = TextUtil.normalizeRepositoryName(input.substring(0, input.length() - 1));
        }
        return repoP3.matcher(repoP2.matcher(repoP1.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll(EMPTY_STRING)).replaceAll(EMPTY_STRING)).replaceAll(EMPTY_STRING);
    }

    public static String normalizeUserName(String input) {
        nonASCIIm1.reset(Normalizer.normalize(input, Normalizer.Form.NFD));
        return nonASCIIm2.reset(nonASCIIm1.replaceAll(EMPTY_STRING)).replaceAll(EMPTY_STRING);
    }
}

