/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.events.AuthorizationPolicySavedEvent;
import org.uberfire.backend.server.authz.AuthorizationPolicyDeployer;
import org.uberfire.backend.server.authz.AuthorizationServiceImpl;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthorizationServiceTest {
    AuthorizationServiceImpl authorizationService;
    AuthorizationPolicyDeployer deployer;
    @Mock
    AuthorizationPolicyStorage storage;
    @Mock
    Event<AuthorizationPolicyDeployedEvent> event;
    @Mock
    Event<AuthorizationPolicySavedEvent> policySavedEvent;
    PermissionManager permissionManager;
    private static final String path = "WEB-INF/classes/security-policy.properties";

    @Before
    public void setUp() {
        DefaultPermissionTypeRegistry permissionTypeRegistry = new DefaultPermissionTypeRegistry();
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager((PermissionTypeRegistry)permissionTypeRegistry));
        this.deployer = new AuthorizationPolicyDeployer(this.storage, this.permissionManager, this.event);
        this.authorizationService = new AuthorizationServiceImpl(this.storage, this.permissionManager, this.policySavedEvent);
    }

    @Test
    public void testPolicyLoad() throws Exception {
        this.getPolicyFromPath(path);
    }

    @Test
    public void testPolicySave() throws Exception {
        Path policyDir = this.getPolicyFromPath(path);
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        AuthorizationPolicy ap = (AuthorizationPolicy)policyCaptor.getValue();
        this.authorizationService.savePolicy(ap);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)2))).setAuthorizationPolicy(ap);
        ((Event)Mockito.verify(this.policySavedEvent)).fire(Matchers.any());
    }

    @Test
    public void testPolicyDelete() throws Exception {
        Path policyDir = this.getPolicyFromPath(path);
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        AuthorizationPolicy ap = (AuthorizationPolicy)policyCaptor.getValue();
        GroupImpl group = new GroupImpl("group1");
        this.authorizationService.deletePolicyByGroup((Group)group, ap);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).deletePolicyByGroup((Group)group, ap);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)2))).setAuthorizationPolicy((AuthorizationPolicy)Matchers.any());
        ((Event)Mockito.verify(this.policySavedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any());
    }

    private Path getPolicyFromPath(String path) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(path);
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        Assert.assertNotNull((Object)policyDir);
        return policyDir;
    }
}

