/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.watch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutorImpl;
import org.uberfire.backend.server.util.Filter;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChangeType;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class IOWatchServiceExecutorImplTest {
    private static final String COMMIT_MESSAGE = "COMMIT_MESSAGE";
    private static final String SESSION_ID = "SESSION_ID";
    private static final String USER = "USER";
    private static final String ORIGINAL_FILE1_URI = "file:///originalPath/OriginalFile1.java";
    private static final String NEW_FILE1_URI = "file:///newFilePath/NewFile1.java";
    private static final String ORIGINAL_FILE2_URI = "file:///originalPath/OriginalFile2.java";
    private static final String NEW_FILE2_URI = "file:///newFilePath/NewFile2.java";
    private static final String ORIGINAL_FILE3_URI = "file:///originalPath/OriginalFile3.java";
    private static final String NEW_FILE3_URI = "file:///newFilePath/NewFile3.java";
    private static final String ORIGINAL_FILE4_URI = "file:///originalPath/OriginalFile4.java";
    private static final String NEW_FILE4_URI = "file:///newFilePath/NewFile4.java";
    @Mock
    private EventSourceMock<ResourceBatchChangesEvent> resourceBatchChanges;
    @Mock
    private EventSourceMock<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Mock
    private EventSourceMock<ResourceRenamedEvent> resourceRenamedEvent;
    @Mock
    private EventSourceMock<ResourceDeletedEvent> resourceDeletedEvent;
    @Mock
    private EventSourceMock<ResourceAddedEvent> resourceAddedEvent;
    @Captor
    private ArgumentCaptor<ResourceUpdatedEvent> resourceUpdatedEventCaptor;
    @Captor
    private ArgumentCaptor<ResourceDeletedEvent> resourceDeletedEventCaptor;
    @Captor
    private ArgumentCaptor<ResourceAddedEvent> resourceAddedEventCaptor;
    @Captor
    private ArgumentCaptor<ResourceRenamedEvent> resourceRenamedEventCaptor;
    @Captor
    private ArgumentCaptor<ResourceBatchChangesEvent> resourceBatchChangesEventCaptor;
    private IOWatchServiceExecutorImpl watchServiceExecutor;

    @Before
    public void setUp() {
        this.watchServiceExecutor = new IOWatchServiceExecutorImpl();
        this.watchServiceExecutor.setEvents(this.resourceBatchChanges, this.resourceUpdatedEvent, this.resourceRenamedEvent, this.resourceDeletedEvent, this.resourceAddedEvent);
    }

    @Test
    public void testSingleEventModify() throws Exception {
        this.testSingleEvent(StandardWatchEventKind.ENTRY_MODIFY, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE);
    }

    @Test
    public void testSingleEventDelete() throws Exception {
        this.testSingleEvent(StandardWatchEventKind.ENTRY_DELETE, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE);
    }

    @Test
    public void testSingleEventCreate() throws Exception {
        this.testSingleEvent(StandardWatchEventKind.ENTRY_CREATE, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE);
    }

    @Test
    public void testSingleEventRename() throws Exception {
        this.testSingleEvent(StandardWatchEventKind.ENTRY_RENAME, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE);
    }

    @Test
    public void testMultipleEvents() throws Exception {
        ArrayList events = new ArrayList();
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_MODIFY, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_RENAME, ORIGINAL_FILE1_URI, NEW_FILE1_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_CREATE, ORIGINAL_FILE2_URI, NEW_FILE2_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_DELETE, ORIGINAL_FILE3_URI, NEW_FILE3_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_CREATE, ORIGINAL_FILE4_URI, NEW_FILE4_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_MODIFY, ORIGINAL_FILE4_URI, NEW_FILE4_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        events.add(this.mockWatchEvent(StandardWatchEventKind.ENTRY_DELETE, ORIGINAL_FILE4_URI, NEW_FILE4_URI, SESSION_ID, USER, COMMIT_MESSAGE));
        WatchKey watchKey = (WatchKey)Mockito.mock(WatchKey.class);
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)watchKey.pollEvents()).thenReturn(events);
        Mockito.when((Object)filter.doFilter(Matchers.any(WatchEvent.class))).thenReturn((Object)false);
        this.watchServiceExecutor.execute(watchKey, filter);
        ((EventSourceMock)Mockito.verify(this.resourceBatchChanges)).fire(this.resourceBatchChangesEventCaptor.capture());
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), ORIGINAL_FILE1_URI, COMMIT_MESSAGE, ResourceChangeType.UPDATE);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), ORIGINAL_FILE1_URI, COMMIT_MESSAGE, ResourceChangeType.RENAME);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), NEW_FILE2_URI, COMMIT_MESSAGE, ResourceChangeType.ADD);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), ORIGINAL_FILE3_URI, COMMIT_MESSAGE, ResourceChangeType.DELETE);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), NEW_FILE4_URI, COMMIT_MESSAGE, ResourceChangeType.ADD);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), ORIGINAL_FILE4_URI, COMMIT_MESSAGE, ResourceChangeType.UPDATE);
        this.verifyResourceChange((ResourceBatchChangesEvent)this.resourceBatchChangesEventCaptor.getValue(), ORIGINAL_FILE4_URI, COMMIT_MESSAGE, ResourceChangeType.DELETE);
    }

    private void verifyResourceChange(ResourceBatchChangesEvent resourceBatchChanges, String originalFile1Uri, String commitMessage, ResourceChangeType changeType) {
        Optional<Collection> expectedResourceChanges = resourceBatchChanges.getBatch().entrySet().stream().filter(entry -> originalFile1Uri.equals(((org.uberfire.backend.vfs.Path)entry.getKey()).toURI())).map(Map.Entry::getValue).findFirst().filter(resourceChanges -> resourceChanges.stream().filter(resourceChange -> resourceChange.getType().equals((Object)changeType) && resourceChange.getMessage().equals(commitMessage)).findFirst().isPresent());
        Assert.assertTrue((String)("Change " + changeType.name() + " was not found for resource: " + originalFile1Uri), (boolean)expectedResourceChanges.isPresent());
    }

    public void testSingleEvent(WatchEvent.Kind kind, String originalPathURI, String newPathURI, String sessionId, String userId, String commitMessage) throws Exception {
        WatchKey watchKey = (WatchKey)Mockito.mock(WatchKey.class);
        Filter filter = (Filter)Mockito.mock(Filter.class);
        ArrayList events = new ArrayList();
        events.add(this.mockWatchEvent(kind, originalPathURI, newPathURI, sessionId, userId, commitMessage));
        Mockito.when((Object)watchKey.pollEvents()).thenReturn(events);
        Mockito.when((Object)filter.doFilter(Matchers.any(WatchEvent.class))).thenReturn((Object)false);
        this.watchServiceExecutor.execute(watchKey, filter);
        if (kind == StandardWatchEventKind.ENTRY_MODIFY) {
            this.verifyResourceUpdatedEvent(originalPathURI, sessionId, userId, commitMessage);
        } else if (kind == StandardWatchEventKind.ENTRY_DELETE) {
            this.verifyResourceDeletedEvent(originalPathURI, sessionId, userId, commitMessage);
        } else if (kind == StandardWatchEventKind.ENTRY_CREATE) {
            this.verifyResourceAddedEvent(newPathURI, sessionId, userId, commitMessage);
        } else {
            this.verifyResourceRenamedEvent(originalPathURI, newPathURI, sessionId, userId, commitMessage);
        }
    }

    private WatchEvent<?> mockWatchEvent(WatchEvent.Kind kind, String originalPathURI, String newPathURI, String sessionId, String userId, String commitMessage) throws URISyntaxException {
        WatchEvent event = (WatchEvent)Mockito.mock(WatchEvent.class);
        Mockito.when((Object)event.kind()).thenReturn((Object)kind);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        HashSet supportedViews = new HashSet();
        Mockito.when((Object)fileSystem.supportedFileAttributeViews()).thenReturn(supportedViews);
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        Mockito.when((Object)context.getSessionId()).thenReturn((Object)sessionId);
        Mockito.when((Object)context.getUser()).thenReturn((Object)userId);
        Mockito.when((Object)context.getMessage()).thenReturn((Object)commitMessage);
        Path oldPath = (Path)Mockito.mock(Path.class);
        URI oldPathUri = new URI(originalPathURI);
        Mockito.when((Object)oldPath.toUri()).thenReturn((Object)oldPathUri);
        Mockito.when((Object)oldPath.getFileSystem()).thenReturn((Object)fileSystem);
        Path path = (Path)Mockito.mock(Path.class);
        URI pathUri = new URI(newPathURI);
        Mockito.when((Object)path.toUri()).thenReturn((Object)pathUri);
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)context.getOldPath()).thenReturn((Object)oldPath);
        Mockito.when((Object)context.getPath()).thenReturn((Object)path);
        Mockito.when((Object)event.context()).thenReturn((Object)context);
        return event;
    }

    private void verifyResourceUpdatedEvent(String file, String sessionId, String userId, String commitMessage) {
        ((EventSourceMock)Mockito.verify(this.resourceUpdatedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.resourceUpdatedEventCaptor.capture());
        Assert.assertEquals((Object)file, (Object)((ResourceUpdatedEvent)this.resourceUpdatedEventCaptor.getValue()).getPath().toURI());
        Assert.assertEquals((Object)sessionId, (Object)((ResourceUpdatedEvent)this.resourceUpdatedEventCaptor.getValue()).getSessionInfo().getId());
        Assert.assertEquals((Object)userId, (Object)((ResourceUpdatedEvent)this.resourceUpdatedEventCaptor.getValue()).getSessionInfo().getIdentity().getIdentifier());
        Assert.assertEquals((Object)commitMessage, (Object)((ResourceUpdatedEvent)this.resourceUpdatedEventCaptor.getValue()).getMessage());
    }

    private void verifyResourceDeletedEvent(String file, String sessionId, String userId, String commitMessage) {
        ((EventSourceMock)Mockito.verify(this.resourceDeletedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.resourceDeletedEventCaptor.capture());
        Assert.assertEquals((Object)file, (Object)((ResourceDeletedEvent)this.resourceDeletedEventCaptor.getValue()).getPath().toURI());
        Assert.assertEquals((Object)sessionId, (Object)((ResourceDeletedEvent)this.resourceDeletedEventCaptor.getValue()).getSessionInfo().getId());
        Assert.assertEquals((Object)userId, (Object)((ResourceDeletedEvent)this.resourceDeletedEventCaptor.getValue()).getSessionInfo().getIdentity().getIdentifier());
        Assert.assertEquals((Object)commitMessage, (Object)((ResourceDeletedEvent)this.resourceDeletedEventCaptor.getValue()).getMessage());
    }

    private void verifyResourceAddedEvent(String file, String sessionId, String userId, String commitMessage) {
        ((EventSourceMock)Mockito.verify(this.resourceAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.resourceAddedEventCaptor.capture());
        Assert.assertEquals((Object)file, (Object)((ResourceAddedEvent)this.resourceAddedEventCaptor.getValue()).getPath().toURI());
        Assert.assertEquals((Object)sessionId, (Object)((ResourceAddedEvent)this.resourceAddedEventCaptor.getValue()).getSessionInfo().getId());
        Assert.assertEquals((Object)userId, (Object)((ResourceAddedEvent)this.resourceAddedEventCaptor.getValue()).getSessionInfo().getIdentity().getIdentifier());
        Assert.assertEquals((Object)commitMessage, (Object)((ResourceAddedEvent)this.resourceAddedEventCaptor.getValue()).getMessage());
    }

    private void verifyResourceRenamedEvent(String file, String destinationFile, String sessionId, String userId, String commitMessage) {
        ((EventSourceMock)Mockito.verify(this.resourceRenamedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.resourceRenamedEventCaptor.capture());
        Assert.assertEquals((Object)file, (Object)((ResourceRenamedEvent)this.resourceRenamedEventCaptor.getValue()).getPath().toURI());
        Assert.assertEquals((Object)destinationFile, (Object)((ResourceRenamedEvent)this.resourceRenamedEventCaptor.getValue()).getDestinationPath().toURI());
        Assert.assertEquals((Object)sessionId, (Object)((ResourceRenamedEvent)this.resourceRenamedEventCaptor.getValue()).getSessionInfo().getId());
        Assert.assertEquals((Object)userId, (Object)((ResourceRenamedEvent)this.resourceRenamedEventCaptor.getValue()).getSessionInfo().getIdentity().getIdentifier());
        Assert.assertEquals((Object)commitMessage, (Object)((ResourceRenamedEvent)this.resourceRenamedEventCaptor.getValue()).getMessage());
    }
}

