/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugins.engine.AbstractPluginsTest;
import org.uberfire.backend.server.plugins.engine.PluginJarProcessor;
import org.uberfire.backend.server.plugins.engine.PluginWatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginWatcherTest
extends AbstractPluginsTest {
    @Spy
    private PluginWatcher pluginWatcher;
    @Mock
    private PluginJarProcessor pluginJarProcessor;
    @Mock
    private ExecutorService executor;
    @Mock
    private Path plugin;
    @Mock
    private Path fileName;

    @After
    public void tearDown() {
        this.pluginWatcher.stop();
    }

    @Test
    public void startSubmitsWatcherThread() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void startDoesNotSubmitWatcherThreadIfPluginDirDoesNotExist() throws Exception {
        this.pluginWatcher.start(this.pluginDir + "invalid", this.executor, this.pluginJarProcessor);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void startOnlyOnce() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void stopEndsWatcherThread() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        Assert.assertTrue((boolean)this.pluginWatcher.active);
        this.pluginWatcher.stop();
        Assert.assertFalse((boolean)this.pluginWatcher.active);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void loadPluginLogsError() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        Mockito.when((Object)this.fileName.toString()).thenReturn((Object)"fileName.jar");
        Mockito.when((Object)this.plugin.getFileName()).thenReturn((Object)this.fileName);
        RuntimeException e = new RuntimeException();
        ((PluginJarProcessor)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.pluginJarProcessor)).loadPlugins((Path)Matchers.any(Path.class), ((Boolean)Matchers.any(Boolean.class)).booleanValue());
        this.pluginWatcher.loadPlugins(this.plugin);
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).logPluginsWatcherError("Failed to process new plugin fileName.jar", (Exception)e, false);
        this.pluginWatcher.stop();
        this.pluginWatcher.loadPlugins(this.plugin);
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).logPluginsWatcherError("Failed to process new plugin fileName.jar", (Exception)e, true);
    }

    @Test
    public void reloadPluginsLogsError() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginJarProcessor);
        Mockito.when((Object)this.fileName.toString()).thenReturn((Object)"fileName.js");
        Mockito.when((Object)this.plugin.getFileName()).thenReturn((Object)this.fileName);
        RuntimeException e = new RuntimeException();
        ((PluginJarProcessor)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.pluginJarProcessor)).reload();
        this.pluginWatcher.reloadPlugins(this.plugin);
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).logPluginsWatcherError("Failed to delete plugin fileName.js", (Exception)e, false);
        this.pluginWatcher.stop();
        this.pluginWatcher.reloadPlugins(this.plugin);
        ((PluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).logPluginsWatcherError("Failed to delete plugin fileName.js", (Exception)e, true);
    }
}

