/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.processors;

import javax.enterprise.event.Event;
import org.jboss.errai.cdi.server.scripts.ScriptRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugins.engine.AbstractPluginsTest;
import org.uberfire.backend.server.plugins.processors.GWTScriptPluginProcessor;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GWTScriptPluginProcessorTest
extends AbstractPluginsTest {
    GWTScriptPluginProcessor processor;
    @Mock
    private ScriptRegistry scriptRegistry;
    @Mock
    private Event<PluginAddedEvent> pluginAddedEvent;
    @Mock
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.processor = new GWTScriptPluginProcessor(this.scriptRegistry, this.pluginAddedEvent, this.pluginUpdatedEvent);
    }

    @Test
    public void processTest() {
        Assert.assertFalse((boolean)this.processor.isRegistered("test-app.nocache.js"));
        this.processor.process("test-app.nocache.js", this.pluginDeploymentDir, true);
        Assert.assertTrue((boolean)this.processor.isRegistered("test-app.nocache.js"));
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry, (VerificationMode)Mockito.times((int)1))).addScript((String)Matchers.eq((Object)"UF"), Matchers.anyString());
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any());
        this.processor.process("test-app.nocache.js", this.pluginDeploymentDir, true);
        ((Event)Mockito.verify(this.pluginUpdatedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any());
    }

    @Test
    public void shutDownShouldRemoveScripts() throws Exception {
        this.processor.shutDown();
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry, (VerificationMode)Mockito.times((int)1))).removeScripts("UF");
    }

    @Test
    public void removeAllShouldClearPluginsAndScriptRegistry() throws Exception {
        this.processor.availablePlugins.add("test");
        Assert.assertFalse((boolean)this.processor.availablePlugins.isEmpty());
        this.processor.removeAll();
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry, (VerificationMode)Mockito.times((int)1))).removeScripts("UF");
        Assert.assertTrue((boolean)this.processor.availablePlugins.isEmpty());
    }

    @Test
    public void shouldProcessTest() throws Exception {
        Assert.assertFalse((boolean)this.processor.shouldProcess("pluginname.html"));
        Assert.assertTrue((boolean)this.processor.shouldProcess("pluginname.nocache.js"));
    }
}

