/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.security.utils.BasicAuthorizationPrincipal;
import org.uberfire.backend.server.security.adapter.GroupAdapterAuthorizationSource;

public class GroupAdapterAuthorizationSourceTest {
    GroupAdapterAuthorizationSource adapter = new GroupAdapterAuthorizationSource();

    @Test
    public void testConcurrency() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(4);
        CountDownLatch latch = new CountDownLatch(12);
        for (int i = 0; i < 12; ++i) {
            service.submit(() -> {
                try {
                    this.adapter.collectEntitiesFromAdapters(null, null);
                    latch.countDown();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        service.shutdown();
        Assert.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
    }

    @Test
    public void skipBasicAuthorizationPrincipalTest() {
        HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
        principals.add(new JMXPrincipal("admin"));
        principals.add((JMXPrincipal)new BasicAuthorizationPrincipal("analyst"));
        principals.add(new JMXPrincipal("developer"));
        Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
        List entities = this.adapter.collectEntitiesFromSubject("admin", subject, new String[0]);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)"admin", entities.get(0));
        Assert.assertEquals((Object)"developer", entities.get(1));
    }
}

