/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.servlet;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.servlet.ReleaseUserLocksServlet;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ReleaseUserLocksServletTest {
    @Mock
    private VFSLockService vfsLockService;
    @InjectMocks
    private ReleaseUserLocksServlet releaseUserLocksServlet;

    @Test
    public void releaseUserLocksWhenInvalidSessionTest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)request)).getSession();
        this.releaseUserLocksServlet.doGet(request, response);
        ((VFSLockService)Mockito.verify((Object)this.vfsLockService, (VerificationMode)Mockito.never())).releaseLock((Path)Matchers.any(Path.class));
    }

    @Test
    public void releaseUserLocksWhenNoLockAttributeTest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        ((HttpServletRequest)Mockito.doReturn((Object)session).when((Object)request)).getSession();
        ((HttpSession)Mockito.doReturn(null).when((Object)session)).getAttribute("uf-locks");
        this.releaseUserLocksServlet.doGet(request, response);
        ((VFSLockService)Mockito.verify((Object)this.vfsLockService, (VerificationMode)Mockito.never())).releaseLock((Path)Matchers.any(Path.class));
    }

    @Test
    public void releaseUserLocksSuccessTest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        HashSet<Object> locks = new HashSet<Object>();
        locks.add(Mockito.mock(LockInfo.class));
        ((HttpServletRequest)Mockito.doReturn((Object)session).when((Object)request)).getSession();
        ((HttpSession)Mockito.doReturn(locks).when((Object)session)).getAttribute("uf-locks");
        this.releaseUserLocksServlet.doGet(request, response);
        ((VFSLockService)Mockito.verify((Object)this.vfsLockService)).releaseLock((Path)Matchers.any());
    }
}

