/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util.gzip;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.gzip.GzipFilter;

public class GzipFilterTest {
    @Before
    public void before() {
        System.clearProperty("org.uberfire.gzip.enable");
    }

    @Test
    public void doFilter_compress() throws IOException, ServletException {
        GzipFilter gzipFilter = (GzipFilter)Mockito.spy((Object)new GzipFilter());
        Mockito.when((Object)gzipFilter.getAction((ServletRequest)ArgumentMatchers.any())).thenReturn((Object)GzipFilter.Action.COMPRESS);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        gzipFilter.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(HttpServletResponse.class), chain);
        ((GzipFilter)Mockito.verify((Object)gzipFilter, (VerificationMode)Mockito.times((int)1))).compressAndContinue((ServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), (FilterChain)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
    }

    @Test
    public void doFilter_doNotCompress() throws IOException, ServletException {
        GzipFilter gzipFilter = (GzipFilter)Mockito.spy((Object)new GzipFilter());
        Mockito.when((Object)gzipFilter.getAction((ServletRequest)ArgumentMatchers.any())).thenReturn((Object)GzipFilter.Action.DO_NOT_COMPRESS);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        gzipFilter.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(HttpServletResponse.class), chain);
        ((GzipFilter)Mockito.verify((Object)gzipFilter, (VerificationMode)Mockito.never())).compressAndContinue((ServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), (FilterChain)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
    }

    @Test
    public void doFilter_doNotAcceptGzip() throws IOException, ServletException {
        GzipFilter gzipFilter = (GzipFilter)Mockito.spy((Object)new GzipFilter());
        Mockito.when((Object)gzipFilter.getAction((ServletRequest)ArgumentMatchers.any())).thenReturn((Object)GzipFilter.Action.DO_NOT_ACCEPT_GZIP);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        gzipFilter.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(HttpServletResponse.class), chain);
        ((GzipFilter)Mockito.verify((Object)gzipFilter, (VerificationMode)Mockito.never())).compressAndContinue((ServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), (FilterChain)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
    }

    @Test
    public void doFilter_halt() throws IOException, ServletException {
        GzipFilter gzipFilter = (GzipFilter)Mockito.spy((Object)new GzipFilter());
        Mockito.when((Object)gzipFilter.getAction((ServletRequest)ArgumentMatchers.any())).thenReturn((Object)GzipFilter.Action.HALT);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        gzipFilter.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(HttpServletResponse.class), chain);
        ((GzipFilter)Mockito.verify((Object)gzipFilter, (VerificationMode)Mockito.never())).compressAndContinue((ServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), (FilterChain)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
    }

    @Test
    public void getAction_notHttpServletRequest() {
        GzipFilter gzipFilter = new GzipFilter();
        Assert.assertEquals((Object)GzipFilter.Action.HALT, (Object)gzipFilter.getAction((ServletRequest)Mockito.mock(ServletRequest.class)));
    }

    @Test
    public void getAction_disableGzipCompressionViaSystemProperty() {
        GzipFilter gzipFilter = new GzipFilter();
        System.setProperty("org.uberfire.gzip.enable", "false");
        Assert.assertEquals((Object)GzipFilter.Action.DO_NOT_COMPRESS, (Object)gzipFilter.getAction((ServletRequest)Mockito.mock(HttpServletRequest.class)));
        System.setProperty("org.uberfire.gzip.enable", "falsy");
        Assert.assertEquals((Object)GzipFilter.Action.DO_NOT_COMPRESS, (Object)gzipFilter.getAction((ServletRequest)Mockito.mock(HttpServletRequest.class)));
    }

    @Test
    public void getAction_doNotAcceptEncodingGzip() {
        GzipFilter gzipFilter = new GzipFilter();
        HttpServletRequest mock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Assert.assertEquals((Object)GzipFilter.Action.DO_NOT_ACCEPT_GZIP, (Object)gzipFilter.getAction((ServletRequest)mock));
        Mockito.when((Object)mock.getHeader((String)ArgumentMatchers.eq((Object)"Accept-Encoding"))).thenReturn((Object)"foo");
        Assert.assertEquals((Object)GzipFilter.Action.DO_NOT_ACCEPT_GZIP, (Object)gzipFilter.getAction((ServletRequest)mock));
    }

    @Test
    public void getAction_acceptEncodingGzip() {
        GzipFilter gzipFilter = new GzipFilter();
        HttpServletRequest mock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mock.getHeader((String)ArgumentMatchers.eq((Object)"Accept-Encoding"))).thenReturn((Object)"gzip");
        Assert.assertEquals((Object)GzipFilter.Action.COMPRESS, (Object)gzipFilter.getAction((ServletRequest)mock));
    }
}

