/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.VFSServicesServerImpl;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=MockitoJUnitRunner.class)
public class VFSServicesServerImplTest {
    private static final org.uberfire.backend.vfs.Path ROOT_PATH = PathFactory.newPath((String)"root", (String)"file://root");
    private static final String ROOT_URI = ROOT_PATH.toURI();
    private static Set<String> FS_ATTRIBUTES = new HashSet<String>(){
        {
            this.add("version");
        }
    };
    @Mock
    private IOService ioService;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private Path rootPath;
    private VFSServicesServerImpl tested;
    private URI rootUri;
    private final org.uberfire.java.nio.file.DirectoryStream<Path> rootDirectoryStream = new org.uberfire.java.nio.file.DirectoryStream<Path>(){

        public void close() throws IOException {
        }

        public Iterator<Path> iterator() {
            return Collections.singletonList(VFSServicesServerImplTest.this.rootPath).iterator();
        }
    };

    @Before
    public void setup() throws Exception {
        this.rootUri = new URI(ROOT_URI);
        Mockito.when((Object)this.fileSystem.supportedFileAttributeViews()).thenReturn(FS_ATTRIBUTES);
        Mockito.when((Object)this.rootPath.toUri()).thenReturn((Object)this.rootUri);
        Mockito.when((Object)this.rootPath.getFileSystem()).thenReturn((Object)this.fileSystem);
        ((IOService)Mockito.doAnswer(invocationOnMock -> {
            URI arg = (URI)invocationOnMock.getArguments()[0];
            return arg.toURL().toString().equals(ROOT_URI) ? this.rootPath : null;
        }).when((Object)this.ioService)).get((URI)ArgumentMatchers.any(URI.class));
        this.tested = new VFSServicesServerImpl(this.ioService);
    }

    @Test
    public void testGet() {
        org.uberfire.backend.vfs.Path path = this.tested.get(ROOT_URI);
        Assert.assertEquals((Object)ROOT_URI, (Object)path.toURI());
    }

    @Test
    public void testNewDirectoryStream() {
        ((IOService)Mockito.doAnswer(invocationOnMock -> this.rootDirectoryStream).when((Object)this.ioService)).newDirectoryStream((Path)ArgumentMatchers.any(Path.class));
        DirectoryStream paths = this.tested.newDirectoryStream(ROOT_PATH);
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)paths.iterator().next();
        Assert.assertEquals((Object)ROOT_PATH, (Object)path);
    }

    @Test
    public void testNewDirectoryStreamFiltered() {
        DirectoryStream.Filter filter = (DirectoryStream.Filter)Mockito.mock(DirectoryStream.Filter.class);
        ((IOService)Mockito.doAnswer(invocationOnMock -> {
            DirectoryStream.Filter argFilter = (DirectoryStream.Filter)invocationOnMock.getArguments()[1];
            argFilter.accept((Object)this.rootPath);
            return this.rootDirectoryStream;
        }).when((Object)this.ioService)).newDirectoryStream((Path)ArgumentMatchers.any(Path.class), (DirectoryStream.Filter)ArgumentMatchers.any(DirectoryStream.Filter.class));
        DirectoryStream paths = this.tested.newDirectoryStream(ROOT_PATH, filter);
        ((DirectoryStream.Filter)Mockito.verify((Object)filter, (VerificationMode)Mockito.times((int)1))).accept(ArgumentMatchers.eq((Object)ROOT_PATH));
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)paths.iterator().next();
        Assert.assertEquals((Object)ROOT_PATH, (Object)path);
    }

    @Test
    public void testCreateDirectory() {
        this.tested.createDirectory(ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).createDirectory((Path)ArgumentMatchers.any(Path.class), new FileAttribute[0]);
    }

    @Test
    public void testCreateDirectoryWithAttributes() {
        Map attributes = (Map)Mockito.mock(Map.class);
        this.tested.createDirectory(ROOT_PATH, attributes);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).createDirectory((Path)ArgumentMatchers.any(Path.class), (Map)ArgumentMatchers.eq((Object)attributes));
    }

    @Test
    public void testCreateDirectories() {
        this.tested.createDirectories(ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).createDirectories((Path)ArgumentMatchers.any(Path.class), new FileAttribute[0]);
    }

    @Test
    public void testCreateDirectoriesWithAttributes() {
        Map attributes = (Map)Mockito.mock(Map.class);
        this.tested.createDirectories(ROOT_PATH, attributes);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).createDirectories((Path)ArgumentMatchers.any(Path.class), (Map)ArgumentMatchers.eq((Object)attributes));
    }

    @Test
    public void testSetAttributes() {
        Map attributes = (Map)Mockito.mock(Map.class);
        this.tested.setAttributes(ROOT_PATH, attributes);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).setAttributes((Path)ArgumentMatchers.any(Path.class), (Map)ArgumentMatchers.eq((Object)attributes));
    }

    @Test
    public void testDelete() {
        this.tested.delete(ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).delete((Path)ArgumentMatchers.any(Path.class), new DeleteOption[0]);
    }

    @Test
    public void testDeleteIfExists() {
        this.tested.deleteIfExists(ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).deleteIfExists((Path)ArgumentMatchers.any(Path.class), new DeleteOption[0]);
    }

    @Test
    public void testCopy() {
        this.tested.copy(ROOT_PATH, ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).copy((Path)ArgumentMatchers.any(Path.class), (Path)ArgumentMatchers.any(Path.class), new CopyOption[0]);
    }

    @Test
    public void testMove() {
        this.tested.move(ROOT_PATH, ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).move((Path)ArgumentMatchers.any(Path.class), (Path)ArgumentMatchers.any(Path.class), new CopyOption[0]);
    }

    @Test
    public void testReadAllString() {
        this.tested.readAllString(ROOT_PATH);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).readAllString((Path)ArgumentMatchers.any(Path.class));
    }

    @Test
    public void testWrite() {
        String content = "some-content-goes-here";
        this.tested.write(ROOT_PATH, "some-content-goes-here");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.eq((Object)"some-content-goes-here"), new OpenOption[0]);
    }

    @Test
    public void testWriteWithAttributes() {
        Map attributes = (Map)Mockito.mock(Map.class);
        String content = "some-content-goes-here";
        this.tested.write(ROOT_PATH, "some-content-goes-here", attributes);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.eq((Object)"some-content-goes-here"), (Map)ArgumentMatchers.eq((Object)attributes), new OpenOption[0]);
    }
}

