/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.uberfire.backend.server.util.gzip.GzipResponseServletOutputStream;

class GzipHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse response;
    private ServletOutputStream stream;
    private PrintWriter writer;

    GzipHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
        this.stream = null;
        this.writer = null;
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream() was already called");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getWriter() was already called");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, StandardCharsets.UTF_8));
        return this.writer;
    }

    public void setContentLength(int length) {
    }

    private ServletOutputStream createOutputStream() throws IOException {
        return new GzipResponseServletOutputStream(this.response);
    }

    void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

