/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.watch;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.io.watch.AbstractIOWatchService;
import org.uberfire.backend.server.io.watch.AsyncWatchService;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutor;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.ClosedWatchServiceException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.InterruptedException;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.Watchable;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractIOWatchServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddWatchServiceException() {
        try {
            System.setProperty("org.uberfire.watcher.autostart", "false");
            AbstractIOWatchService service = new AbstractIOWatchService(null, null, null, null, null, Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory())){

                public boolean doFilter(WatchEvent<?> t) {
                    return false;
                }
            };
            WatchService ws = new WatchService(){

                public void close() throws IOException {
                }

                public WatchKey poll() throws ClosedWatchServiceException {
                    return null;
                }

                public WatchKey poll(long timeout, TimeUnit unit) throws ClosedWatchServiceException, InterruptedException {
                    return null;
                }

                public WatchKey take() throws ClosedWatchServiceException, InterruptedException {
                    return new WatchKey(){

                        public boolean isValid() {
                            return false;
                        }

                        public List<WatchEvent<?>> pollEvents() {
                            return null;
                        }

                        public boolean reset() {
                            return false;
                        }

                        public void cancel() {
                        }

                        public Watchable watchable() {
                            return null;
                        }
                    };
                }

                public boolean isClose() {
                    return false;
                }
            };
            service.addWatchService((FileSystem)Mockito.mock(FileSystem.class), ws);
            Set watchThreads = null;
            try {
                Field field = AbstractIOWatchService.class.getDeclaredField("watchThreads");
                field.setAccessible(true);
                watchThreads = (Set)field.get(service);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            AsyncWatchService asyncWatchService = (AsyncWatchService)watchThreads.iterator().next();
            IOWatchServiceExecutor wsExecutor = (watchKey, filter) -> {
                throw new RuntimeException("dummy");
            };
            try {
                asyncWatchService.execute(wsExecutor);
                Assert.assertTrue((boolean)true);
            }
            catch (Exception e) {
                Assert.fail((String)"Exception is thrown from asyncWatchService.execute()");
            }
        }
        finally {
            System.clearProperty("org.uberfire.watcher.autostart");
        }
    }
}

