/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.uberfire.backend.server.security.JAASAuthenticationService;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.backend.server.security.adapter.WebSphereGroupsAdapter;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JAASAuthenticationService.class})
@PowerMockIgnore(value={"javax.security.*", "javax.naming.*"})
public class JAASAuthenticationServiceTest {
    private JAASAuthenticationService tested;

    @Before
    public void setup() {
        RoleRegistry.get().clear();
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        this.tested = (JAASAuthenticationService)Mockito.spy((Object)new JAASAuthenticationService("ApplicationRealm"));
    }

    @Test
    public void testNoLogin() throws Exception {
        Assert.assertEquals((Object)User.ANONYMOUS, (Object)this.tested.getUser());
    }

    @Test
    public void testGetAnnonymous() throws Exception {
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testLogin() throws Exception {
        String username = "user1";
        String password = "password1";
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
    }

    @Test
    public void testLoginSwitchesClassloaderForJsm() throws Exception {
        PowerMockito.mockStatic(JAASAuthenticationService.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Thread.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(System.class, (Class[])new Class[0]);
        ClassLoader tccl = (ClassLoader)Mockito.mock(ClassLoader.class);
        Thread thread = (Thread)Mockito.mock(Thread.class);
        Mockito.when((Object)Thread.currentThread()).thenReturn((Object)thread);
        Mockito.when((Object)System.getSecurityManager()).thenReturn((Object)((SecurityManager)Mockito.mock(SecurityManager.class)));
        Mockito.when((Object)thread.getContextClassLoader()).thenReturn((Object)tccl);
        String username = "user1";
        String password = "password1";
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.tested.login(username, password);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{thread});
        ((Thread)inOrder.verify((Object)thread)).setContextClassLoader(this.tested.getClass().getClassLoader());
        ((Thread)inOrder.verify((Object)thread)).setContextClassLoader((ClassLoader)ArgumentMatchers.same((Object)tccl));
    }

    @Test
    public void testLoginNoPrincipal() throws Exception {
        String username = "user1";
        String password = "password1";
        Subject subject = new Subject();
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)0L, (long)user.getRoles().size());
        Assert.assertEquals((long)0L, (long)user.getGroups().size());
    }

    @Test
    public void testLoginSubjectGroups() throws Exception {
        String username = "user1";
        String password = "password1";
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        java.security.acl.Group aclGroup = (java.security.acl.Group)Mockito.mock(java.security.acl.Group.class);
        ((java.security.acl.Group)Mockito.doReturn((Object)"Roles").when((Object)aclGroup)).getName();
        Set<Principal> aclGroups = this.mockPrincipals("g1", "g2");
        Enumeration<Principal> aclGroupsEnum = Collections.enumeration(aclGroups);
        ((java.security.acl.Group)Mockito.doReturn(aclGroupsEnum).when((Object)aclGroup)).members();
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        subject.getPrincipals().add((Principal)aclGroup);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)3L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g2")));
    }

    @Test
    public void testLoginSubjectGroupsWithRegexRoleMapper() throws Exception {
        RoleRegistry.get().clear();
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("user");
        RoleRegistry.get().registerRole("role1");
        System.setProperty("org.uberfire.regex.role_mapper", "cn[\\ ]*=[\\ ]*role");
        JAASAuthenticationService sshClient = (JAASAuthenticationService)Mockito.spy((Object)new JAASAuthenticationService("ApplicationRealm"));
        String username = "user1";
        String password = "password1";
        Set<Principal> principals = this.mockPrincipals("ldap", "role1");
        java.security.acl.Group aclGroup = (java.security.acl.Group)Mockito.mock(java.security.acl.Group.class);
        ((java.security.acl.Group)Mockito.doReturn((Object)"Roles").when((Object)aclGroup)).getName();
        Set<Principal> aclGroups = this.mockPrincipals("g1", "g2");
        Enumeration<Principal> aclGroupsEnum = Collections.enumeration(aclGroups);
        ((java.security.acl.Group)Mockito.doReturn(aclGroupsEnum).when((Object)aclGroup)).members();
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        subject.getPrincipals().add((Principal)aclGroup);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)sshClient)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        WebSphereGroupsAdapter wsga = (WebSphereGroupsAdapter)Mockito.mock(WebSphereGroupsAdapter.class);
        List<Group> groups = this.mockGroups("cn=admin,ou=groups,dc=com,dc=example", "cn=user");
        ((WebSphereGroupsAdapter)Mockito.doReturn(groups).when((Object)wsga)).getGroups(ArgumentMatchers.anyString(), Mockito.anyObject());
        ArrayList<WebSphereGroupsAdapter> list = new ArrayList<WebSphereGroupsAdapter>();
        list.add(wsga);
        Whitebox.setInternalState((Object)sshClient, (String)"groupsAdapters", list);
        User user = sshClient.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)3L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("user")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)3L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g2")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("ldap")));
    }

    @Test
    public void testLoggedIn() throws Exception {
        String username = "user1";
        String password = "password1";
        Set<Principal> principals = this.mockPrincipals("admin");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.tested.login(username, password);
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testGetUser() throws Exception {
        String username = "user1";
        String password = "password1";
        RoleRegistry.get().registerRole("admin");
        Set<Principal> principals = this.mockPrincipals("admin");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        User user = this.tested.login(username, password);
        User user1 = this.tested.getUser();
        Assert.assertEquals((Object)user, (Object)user1);
    }

    private Set<Principal> mockPrincipals(String ... names) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String name : names) {
            Principal p1 = (Principal)Mockito.mock(Principal.class);
            Mockito.when((Object)p1.getName()).thenReturn((Object)name);
            principals.add(p1);
        }
        return principals;
    }

    private List<Group> mockGroups(String ... names) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String name : names) {
            Group g = (Group)Mockito.mock(Group.class);
            Mockito.when((Object)g.getName()).thenReturn((Object)name);
            groups.add(g);
        }
        return groups;
    }
}

