/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.security.ElytronAuthenticationService;
import org.uberfire.security.WorkbenchUserManager;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.evidence.Evidence;

public class ElytronAuthenticationServiceTest {
    private ElytronAuthenticationService tested;
    private WorkbenchUserManager workbenchUserManager;

    @Before
    public void setup() {
        this.workbenchUserManager = (WorkbenchUserManager)Mockito.mock(WorkbenchUserManager.class);
        this.tested = new ElytronAuthenticationService(this.workbenchUserManager){

            protected void login(String username, Evidence evidence) throws RealmUnavailableException {
            }
        };
    }

    @Test
    public void testNoLogin() throws Exception {
        Assert.assertEquals((Object)User.ANONYMOUS, (Object)this.tested.getUser());
    }

    @Test
    public void testGetAnonymous() throws Exception {
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testLogin() throws Exception {
        String username = "user1";
        String password = "password1";
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
        User mock = (User)Mockito.mock(User.class);
        ((WorkbenchUserManager)Mockito.doReturn((Object)mock).when((Object)this.workbenchUserManager)).getUser("user1");
        Assert.assertEquals((Object)mock, (Object)this.tested.login("user1", "password1"));
        Assert.assertEquals((Object)mock, (Object)this.tested.getUser());
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
        this.tested.logout();
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test(expected=FailedAuthenticationException.class)
    public void testLoginFailure() throws Exception {
        this.tested = new ElytronAuthenticationService(this.workbenchUserManager){

            protected void login(String username, Evidence evidence) throws RealmUnavailableException {
                throw new RealmUnavailableException();
            }
        };
        String username = "user1";
        String password = "wrong pass";
        User mock = (User)Mockito.mock(User.class);
        ((WorkbenchUserManager)Mockito.doReturn((Object)mock).when((Object)this.workbenchUserManager)).getUser("user1");
        this.tested.login("user1", "wrong pass");
    }
}

