/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Set;
import javax.servlet.http.HttpSession;
import org.jboss.errai.bus.client.api.QueueSession;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.builder.MessageBuildSendableWithReply;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.VFSLockServiceImpl;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class VFSLockServiceTest {
    @InjectMocks
    private VFSLockServiceImpl lockService;
    @Mock
    private IOService ioService;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private QueueSession queueSession;
    @Mock
    private HttpSession httpSession;
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"file-to-lock.txt", (String)"default://file-to-lock.txt");

    @Before
    public void setup() {
        this.setupRpcContext();
        UserImpl testUser = new UserImpl("testUser");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)testUser);
        Mockito.when((Object)((HttpSession)this.queueSession.getAttribute(HttpSession.class, HttpSession.class.getName()))).thenReturn((Object)this.httpSession);
    }

    @Test
    public void acquireLockSucceedsIfFileUnlocked() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"testUser", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockSucceedsIfLockOwned() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"testUser");
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"testUser", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockFailsIfFileLocked() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"some-other-user");
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"some-other-user", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockUpdatesSession() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        this.lockService.acquireLock(this.path);
        ((HttpSession)Mockito.verify((Object)this.httpSession)).setAttribute((String)ArgumentMatchers.eq((Object)"uf-locks"), ArgumentMatchers.any(Set.class));
    }

    @Test
    public void acquireLockUsesBatch() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        this.lockService.acquireLock(this.path);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService});
        ((IOService)inOrder.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)inOrder.verify((Object)this.ioService)).exists((Path)ArgumentMatchers.any(Path.class));
        ((IOService)inOrder.verify((Object)this.ioService)).write((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.any(String.class), new OpenOption[0]);
        ((IOService)inOrder.verify((Object)this.ioService)).endBatch();
    }

    @Test
    public void releaseLockSucceedsIfLockOwned() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"testUser");
        LockResult result = this.lockService.releaseLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockFailsIfLockNotOwned() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"some-other-user");
        try {
            this.lockService.releaseLock(this.path);
            Assert.fail((String)"Expected exception on attempt to release lock not owned by user");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void forceReleaseLockSucceedsIfLockNotOwned() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"some-other-user");
        LockResult result = this.lockService.forceReleaseLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockFailsIfFileUnlocked() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        LockResult result = this.lockService.releaseLock(this.path);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockUpdatesSession() {
        this.lockService.acquireLock(this.path);
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"testUser");
        this.lockService.releaseLock(this.path);
        ((HttpSession)Mockito.verify((Object)this.httpSession)).setAttribute((String)ArgumentMatchers.eq((Object)"uf-locks"), ArgumentMatchers.any(Set.class));
    }

    @Test
    public void releaseLockUsesBatch() {
        this.lockService.acquireLock(this.path);
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"testUser");
        this.lockService.releaseLock(this.path);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService});
        ((IOService)inOrder.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)inOrder.verify((Object)this.ioService)).exists((Path)ArgumentMatchers.any(Path.class));
        ((IOService)inOrder.verify((Object)this.ioService)).readAllString((Path)ArgumentMatchers.any(Path.class));
        ((IOService)inOrder.verify((Object)this.ioService)).delete((Path)ArgumentMatchers.any(Path.class), new DeleteOption[0]);
        ((IOService)inOrder.verify((Object)this.ioService)).endBatch();
    }

    @Test
    public void retrieveLockInfoForLockedFile() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)"some-user");
        LockInfo info = this.lockService.retrieveLockInfo(this.path);
        Assert.assertTrue((boolean)info.isLocked());
        Assert.assertEquals((Object)"some-user", (Object)info.lockedBy());
    }

    @Test
    public void retrieveLockInfoForUnlockedFile() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        LockInfo info = this.lockService.retrieveLockInfo(this.path);
        Assert.assertFalse((boolean)info.isLocked());
        Assert.assertNull((Object)info.lockedBy());
    }

    @Test
    public void retrieveLockInfoNoSuchFileException() {
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)ArgumentMatchers.any(Path.class))).thenThrow(new Throwable[]{new NoSuchFileException()});
        LockInfo info = this.lockService.retrieveLockInfo(this.path);
        Assert.assertFalse((boolean)info.isLocked());
        Assert.assertNull((Object)info.lockedBy());
    }

    private void setupRpcContext() {
        Message message = ((MessageBuildSendableWithReply)MessageBuilder.createMessage((String)"for testing").signalling().done()).getMessage();
        message.setResource("Session", (Object)this.queueSession);
        RpcContext.set((Message)message);
    }
}

