/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.security.ElytronAuthenticationService;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelper;

public class ElytronAuthenticationServiceTest {
    private ElytronAuthenticationService tested;
    private ElytronIdentityHelper elytronIdentityHelper;

    @Before
    public void setup() {
        this.elytronIdentityHelper = (ElytronIdentityHelper)Mockito.mock(ElytronIdentityHelper.class);
        this.tested = new ElytronAuthenticationService(this.elytronIdentityHelper);
    }

    @Test
    public void testNoLogin() throws Exception {
        Assert.assertEquals((Object)User.ANONYMOUS, (Object)this.tested.getUser());
    }

    @Test
    public void testGetAnonymous() throws Exception {
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testLogin() throws Exception {
        String username = "user1";
        String password = "password1";
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
        User mock = (User)Mockito.mock(User.class);
        ((ElytronIdentityHelper)Mockito.doReturn((Object)mock).when((Object)this.elytronIdentityHelper)).getIdentity("user1", "password1");
        Assert.assertEquals((Object)mock, (Object)this.tested.login("user1", "password1"));
        Assert.assertEquals((Object)mock, (Object)this.tested.getUser());
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
        this.tested.logout();
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test(expected=FailedAuthenticationException.class)
    public void testLoginFailure() throws Exception {
        this.tested = new ElytronAuthenticationService(this.elytronIdentityHelper);
        String username = "user1";
        String password = "wrong pass";
        ((ElytronIdentityHelper)Mockito.doThrow((Throwable[])new Throwable[]{new FailedAuthenticationException()}).when((Object)this.elytronIdentityHelper)).getIdentity("user1", "wrong pass");
        this.tested.login("user1", "wrong pass");
    }
}

