/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

public class PathsTest {
    @Test
    public void getFilePathFromProjectRoot() throws Exception {
        Path repositoryRoot = this.getPath("file:///spaceName/repositoryName", "/");
        Path pathToFile = this.getPath("file:///spaceName/repositoryName/org/test/file.txt", "file.txt");
        Assert.assertEquals((Object)"org/test/file.txt", (Object)Paths.removePrefix((Path)pathToFile, (Path)repositoryRoot));
    }

    @Test
    public void getFilePath() throws Exception {
        Path repositoryRoot = this.getPath("file:///spaceName/repositoryName/org/test", "test");
        Path pathToFile = this.getPath("file:///spaceName/repositoryName/org/test/file.txt", "file.txt");
        Assert.assertEquals((Object)"file.txt", (Object)Paths.removePrefix((Path)pathToFile, (Path)repositoryRoot));
    }

    @Test
    public void pathsAreEqual() throws Exception {
        Path repositoryRoot = this.getPath("file:///spaceName/repositoryName/org/test", "test");
        Assert.assertEquals((Object)"", (Object)Paths.removePrefix((Path)repositoryRoot, (Path)repositoryRoot));
    }

    @Test(expected=IllegalArgumentException.class)
    public void pathIsShorterThanPrefix() throws Exception {
        Path repositoryRoot = this.getPath("file:///spaceName/repositoryName/org/test", "test");
        Path pathToFile = this.getPath("file:///spaceName/repositoryName/org/test/file.txt", "file.txt");
        Paths.removePrefix((Path)repositoryRoot, (Path)pathToFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prefixDoesNotMatch() throws Exception {
        Path repositoryRoot = this.getPath("file:///spaceName/repositoryName/org/test", "test");
        Path pathToFile = this.getPath("file:///otherSpace/repositoryName/org/test/file.txt", "file.txt");
        Paths.removePrefix((Path)pathToFile, (Path)repositoryRoot);
    }

    private Path getPath(String uri, String fileName) {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)uri);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        return path;
    }
}

