/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.processors;

import java.io.IOException;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugins.engine.AbstractPluginsTest;
import org.uberfire.backend.server.plugins.processors.HTMLPluginProcessor;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class HTMLPluginProcessorTest
extends AbstractPluginsTest {
    @Mock
    private Event<PluginAddedEvent> pluginAddedEvent;
    @Mock
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;
    private HTMLPluginProcessor processor;

    @Override
    public void setup() {
        this.processor = new HTMLPluginProcessor(this.pluginAddedEvent, this.pluginUpdatedEvent){

            String getPluginContent(String pluginName, String pluginDeploymentDir) throws IOException {
                return "mock";
            }
        };
    }

    @Test
    public void processTest() {
        Assert.assertFalse((boolean)this.processor.isRegistered("dora.html"));
        this.processor.process("dora.html", this.pluginDeploymentDir, true);
        Assert.assertTrue((boolean)this.processor.isRegistered("dora.html"));
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((PluginAddedEvent)ArgumentMatchers.any()));
        this.processor.process("dora.html", this.pluginDeploymentDir, true);
        ((Event)Mockito.verify(this.pluginUpdatedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((PluginUpdatedEvent)ArgumentMatchers.any()));
        Assert.assertTrue((boolean)this.processor.lookupForTemplate("dora.html").isPresent());
    }

    @Test
    public void shouldProcessTest() throws Exception {
        Assert.assertFalse((boolean)this.processor.shouldProcess("pluginname.nocache.js"));
        Assert.assertTrue((boolean)this.processor.shouldProcess("pluginname.html"));
    }
}

