/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.elytron;

import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.security.elytron.DefaultElytronIdentityHelper;
import org.uberfire.security.WorkbenchUserManager;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultElytronIdentityHelperTest {
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private DefaultElytronIdentityHelper helper;
    @Mock
    private WorkbenchUserManager workbenchUserManager;

    @Before
    public void init() {
        this.helper = (DefaultElytronIdentityHelper)Mockito.spy((Object)new DefaultElytronIdentityHelper(this.workbenchUserManager){

            protected boolean login(String userName, String password) {
                return true;
            }
        });
    }

    @Test
    public void testSuccessfulLogin() {
        Mockito.when((Object)this.helper.login((String)ArgumentMatchers.eq((Object)USERNAME), (String)ArgumentMatchers.eq((Object)PASSWORD))).thenReturn((Object)true);
        this.helper.getIdentity(USERNAME, PASSWORD);
        ((WorkbenchUserManager)Mockito.verify((Object)this.workbenchUserManager)).getUser(USERNAME);
    }

    @Test(expected=FailedAuthenticationException.class)
    public void testUnSuccessfulLogin() {
        ((DefaultElytronIdentityHelper)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("whatever error")}).when((Object)this.helper)).login((String)ArgumentMatchers.eq((Object)USERNAME), (String)ArgumentMatchers.eq((Object)PASSWORD));
        this.helper.getIdentity(USERNAME, PASSWORD);
        ((WorkbenchUserManager)Mockito.verify((Object)this.workbenchUserManager, (VerificationMode)Mockito.never())).getUser(USERNAME);
    }
}

