/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.spaces;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class SpacesAPIImplTest {
    SpacesAPIImpl spaces;

    @Before
    public void setup() {
        this.spaces = new SpacesAPIImpl();
    }

    @Test
    public void resolveFileSystemURITest() {
        Assert.assertEquals((Object)"default://system/system", (Object)this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "system").toString());
    }

    @Test
    public void resolveSpaceNameTest() throws Exception {
        Optional space = this.spaces.resolveSpace("default://main@myteam/mortgages/");
        Assert.assertTrue((boolean)space.isPresent());
        Assert.assertEquals((Object)"myteam", (Object)((Space)space.get()).getName());
    }

    @Test
    public void resolveSpaceNameWhenBranchNameHasSlashesTest() throws Exception {
        Optional space = this.spaces.resolveSpace("default://my/main/branch@myteam/mortgages/");
        Assert.assertTrue((boolean)space.isPresent());
        Assert.assertEquals((Object)"myteam", (Object)((Space)space.get()).getName());
    }
}

