/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.mocks.FileSystemTestingUtils;

public class JGitFileSystemLazyCacheTest {
    private static FileSystemTestingUtils fsUtils = new FileSystemTestingUtils();

    @Before
    public void setup() throws IOException {
        System.setProperty("org.uberfire.nio.jgit.cache.instances", "2");
        fsUtils.setup(false);
    }

    @After
    public void cleanupFileSystem() {
        fsUtils.cleanup();
        System.clearProperty("org.uberfire.nio.jgit.cache.instances");
    }

    @Test
    public void basicCache() throws IOException {
        String repoName = "amend-repo-test";
        Path firstWrite = fsUtils.getIoService().get(URI.create("git://" + repoName + "/init1.file"));
        String content = "dora!";
        Path secondWrite = fsUtils.getIoService().get(URI.create("git://" + repoName + "/init2.file"));
        fsUtils.getIoService().write(firstWrite, content, new OpenOption[0]);
        String jgitcontent = fsUtils.getIoService().readAllString(firstWrite);
        Assert.assertEquals((Object)content, (Object)jgitcontent);
        fsUtils.getIoService().write(secondWrite, content, new OpenOption[0]);
        JGitFileSystemProxy fileSystem = (JGitFileSystemProxy)firstWrite.getFileSystem();
        JGitFileSystemProxy fileSystem1 = (JGitFileSystemProxy)secondWrite.getFileSystem();
        Assert.assertEquals((Object)fileSystem, (Object)fileSystem1);
    }

    @Test
    public void regenerateFSCache() throws IOException {
        String defaultRepo = "git://amend-repo-test";
        Path firstWriteFS1 = fsUtils.getIoService().get(URI.create(defaultRepo + "/init1.file"));
        FileSystem fileSystem1Instance1 = firstWriteFS1.getFileSystem();
        String dora1 = "dora1";
        String dora2 = "dora2";
        fsUtils.getIoService().write(firstWriteFS1, dora1, new OpenOption[0]);
        fsUtils.setupJGitRepository(defaultRepo + "2", false);
        Path writeFS2 = fsUtils.getIoService().get(URI.create(defaultRepo + "2/init1.file"));
        fsUtils.getIoService().write(writeFS2, dora1, new OpenOption[0]);
        fsUtils.setupJGitRepository(defaultRepo + "3", false);
        Path writeFS3 = fsUtils.getIoService().get(URI.create(defaultRepo + "3/init1.file"));
        fsUtils.getIoService().write(writeFS3, dora1, new OpenOption[0]);
        fsUtils.setupJGitRepository(defaultRepo, false);
        Path secondWriteFS1 = fsUtils.getIoService().get(URI.create(defaultRepo + "/init2.file"));
        fsUtils.getIoService().write(secondWriteFS1, dora2, new OpenOption[0]);
        FileSystem fileSystem1Instance2 = secondWriteFS1.getFileSystem();
        Assert.assertTrue((System.identityHashCode(fileSystem1Instance1) != System.identityHashCode(fileSystem1Instance2) ? 1 : 0) != 0);
        Assert.assertTrue((fileSystem1Instance1.hashCode() == fileSystem1Instance2.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)fileSystem1Instance1, (Object)fileSystem1Instance2);
        fsUtils.setupJGitRepository(defaultRepo + "5", false);
        fsUtils.setupJGitRepository(defaultRepo + "6", false);
        String actual1 = fsUtils.getIoService().readAllString(fsUtils.getIoService().get(URI.create(defaultRepo + "/init1.file")));
        String actual2 = fsUtils.getIoService().readAllString(fsUtils.getIoService().get(URI.create(defaultRepo + "/init2.file")));
        Assert.assertEquals((Object)dora1, (Object)actual1);
        Assert.assertEquals((Object)dora2, (Object)actual2);
    }

    @Test
    public void branchingTest() throws IOException {
        FileSystem fileSystem = fsUtils.setupJGitRepository("git://dora-repo", true);
        fsUtils.getProvider().forceAsDefault();
        Path branchPath = fileSystem.getPath("branch", new String[]{"dir"});
        Path pathOnBranch = branchPath.resolve("test.file");
        String expected = "dora";
        fsUtils.getIoService().write(pathOnBranch, expected, new OpenOption[0]);
        String actual = fsUtils.getIoService().readAllString(branchPath.resolve("test.file"));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    static {
        System.out.println("Working Dir: " + new File("").getAbsoluteFile().getAbsolutePath());
    }
}

