/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.promise;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.uberfire.client.promise.PromisePolyfillBootstrapper;

@Dependent
public class Promises {
    @PostConstruct
    public void init() {
        PromisePolyfillBootstrapper.ensurePromiseApiIsAvailable();
    }

    @SafeVarargs
    public final <O> Promise<O> all(Promise<O> ... promises) {
        return Arrays.stream(promises).reduce(this.resolve(), (p1, p2) -> p1.then(ignore -> p2));
    }

    public <T, O> Promise<O> all(List<T> objects, Function<T, Promise<O>> f) {
        return objects.stream().map(f).reduce(this.resolve(), (p1, p2) -> p1.then(ignore -> p2));
    }

    public <T, O> Promise<O> reduceLazily(List<T> objects, Function<T, Promise<O>> f) {
        return (Promise)objects.stream().map(o -> () -> (Promise)f.apply(o)).reduce(this::resolve, (p1, p2) -> () -> Promises.lambda$null$7((Supplier)p1, (Supplier)p2)).get();
    }

    public <T, O> Promise<O> reduceLazilyChaining(List<T> objects, BiFunction<Supplier<Promise<O>>, T, Promise<O>> f) {
        return (Promise)((Supplier)objects.stream().map(o -> next -> () -> Promises.lambda$null$9(f, (Supplier)next, o)).reduce(next -> this::resolve, (p1, p2) -> uberNext -> () -> Promises.lambda$null$16(p2, (Supplier)uberNext, p1)).apply(this::resolve)).get();
    }

    public <T, S> Promise<S> promisify(Caller<T> caller, Function<T, S> call) {
        return this.create((resolve, reject) -> call.apply(caller.call(arg_0 -> ((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)resolve).onInvoke(arg_0), this.defaultRpcErrorCallback(reject))));
    }

    public <T, S> Promise<S> promisify(Caller<T> caller, Consumer<T> call) {
        return this.create((resolve, reject) -> call.accept(caller.call(arg_0 -> ((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)resolve).onInvoke(arg_0), this.defaultRpcErrorCallback(reject))));
    }

    private <M> ErrorCallback<M> defaultRpcErrorCallback(Promise.PromiseExecutorCallbackFn.RejectCallbackFn reject) {
        return (o, throwable) -> {
            reject.onInvoke(new Error(o, throwable));
            return false;
        };
    }

    public <V, T> Promise<T> catchOrExecute(Object o, Function<RuntimeException, Promise<T>> catchBlock, Function<V, Promise<T>> expectedRejectionHandler) {
        if (o instanceof JavaScriptObject) {
            return this.resolve().then(i -> (Promise)catchBlock.apply(new RuntimeException("Client-side exception inside Promise: " + o.toString()))).catch_(this::handleCatchBlockExceptions);
        }
        if (o instanceof RuntimeException) {
            return this.resolve().then(i -> (Promise)catchBlock.apply((RuntimeException)o)).catch_(this::handleCatchBlockExceptions);
        }
        if (o instanceof Error) {
            return this.resolve().then(i -> (Promise)catchBlock.apply((RuntimeException)((Error)o).getThrowable())).catch_(this::handleCatchBlockExceptions);
        }
        return expectedRejectionHandler.apply(o);
    }

    private <T> Promise<T> handleCatchBlockExceptions(Object rejectedObject) {
        if (rejectedObject instanceof Throwable) {
            GWT.getUncaughtExceptionHandler().onUncaughtException((Throwable)rejectedObject);
            return this.resolve();
        }
        return this.reject(rejectedObject);
    }

    public <T> Promise<T> resolve() {
        return this.resolve(null);
    }

    public <T> Promise<T> resolve(T object) {
        return this.create((resolve, reject) -> resolve.onInvoke(object));
    }

    public <T> Promise<T> reject(Object object) {
        return this.create((resolve, reject) -> reject.onInvoke(object));
    }

    public <T> Promise<T> create(Promise.PromiseExecutorCallbackFn<T> executor) {
        return new Promise(executor);
    }

    private static /* synthetic */ Promise lambda$null$16(Function p2, Supplier uberNext, Function p1) {
        Supplier next = (Supplier)p2.apply(uberNext);
        Supplier<Promise> chain = () -> Promises.lambda$null$14((Supplier)next, (Supplier)uberNext);
        return ((Promise)((Supplier)p1.apply(chain)).get()).then(arg_0 -> Promises.lambda$null$15((Supplier)next, arg_0));
    }

    private static /* synthetic */ IThenable lambda$null$15(Supplier next, Object ignore) {
        return (Promise)next.get();
    }

    private static /* synthetic */ Promise lambda$null$14(Supplier next, Supplier uberNext) {
        return ((Promise)next.get()).then(arg_0 -> Promises.lambda$null$13((Supplier)uberNext, arg_0));
    }

    private static /* synthetic */ IThenable lambda$null$13(Supplier uberNext, Object ignore) {
        return (Promise)uberNext.get();
    }

    private static /* synthetic */ Promise lambda$null$9(BiFunction f, Supplier next, Object o) {
        return (Promise)f.apply(next, o);
    }

    private static /* synthetic */ Promise lambda$null$7(Supplier p1, Supplier p2) {
        return ((Promise)p1.get()).then(arg_0 -> Promises.lambda$null$6((Supplier)p2, arg_0));
    }

    private static /* synthetic */ IThenable lambda$null$6(Supplier p2, Object ignore) {
        return (Promise)p2.get();
    }

    public static class Error<T> {
        private final T o;
        private final Throwable throwable;

        private Error(T o, Throwable throwable) {
            this.o = o;
            this.throwable = throwable;
        }

        private T getObject() {
            return this.o;
        }

        private Throwable getThrowable() {
            return this.throwable;
        }
    }
}

