/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.util.Cookie;

public class CookieTest {
    Cookie cookie;

    @Before
    public void setup() {
        this.cookie = (Cookie)Mockito.spy(Cookie.class);
    }

    @Test
    public void emptyCookie() {
        ((Cookie)Mockito.doReturn((Object)"").when((Object)this.cookie)).get();
        String value = this.cookie.get("key1");
        Assert.assertEquals((Object)"", (Object)value);
    }

    @Test
    public void inexistentSingleCookie() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1").when((Object)this.cookie)).get();
        String value = this.cookie.get("key2");
        Assert.assertEquals((Object)"", (Object)value);
    }

    @Test
    public void singleCookie() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1").when((Object)this.cookie)).get();
        String value = this.cookie.get("key1");
        Assert.assertEquals((Object)"val1", (Object)value);
    }

    @Test
    public void inexistentMultipleCookies() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1; key2=val2; key3=val3").when((Object)this.cookie)).get();
        String value = this.cookie.get("key4");
        Assert.assertEquals((Object)"", (Object)value);
    }

    @Test
    public void firstMultipleCookies() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1; key2=val2; key3=val3").when((Object)this.cookie)).get();
        String value = this.cookie.get("key1");
        Assert.assertEquals((Object)"val1", (Object)value);
    }

    @Test
    public void middleMultipleCookies() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1; key2=val2; key3=val3").when((Object)this.cookie)).get();
        String value = this.cookie.get("key2");
        Assert.assertEquals((Object)"val2", (Object)value);
    }

    @Test
    public void lastMultipleCookies() {
        ((Cookie)Mockito.doReturn((Object)"key1=val1; key2=val2; key3=val3").when((Object)this.cookie)).get();
        String value = this.cookie.get("key3");
        Assert.assertEquals((Object)"val3", (Object)value);
    }
}

