/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Generated;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import javax.inject.Named;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;

import org.uberfire.mvp.PlaceRequest;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import org.uberfire.client.mvp.TemplatedActivity;
import org.uberfire.client.workbench.panels.impl.TemplatedWorkbenchPanelPresenter;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.NamedPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@Dependent
@Generated("org.uberfire.annotations.processors.WorkbenchPerspectiveProcessor")
@Named("TwitterBootstrapPerspective")
/*
 * WARNING! This class is generated. Do not modify.
 */
public class TwitterBootstrapPerspectiveActivity extends AbstractWorkbenchPerspectiveActivity implements TemplatedActivity {

    @Inject
    private TwitterBootstrapPerspective realPresenter;

    @Inject
    //Constructor injection for testing
    public TwitterBootstrapPerspectiveActivity(final PlaceManager placeManager) {
        super( placeManager );
    }

    @Override
    public String getIdentifier() {
        return "TwitterBootstrapPerspective";
    }

    @Override
    public IsWidget getRootWidget() {
        return realPresenter;
    }

    @Override
    public HasWidgets resolvePosition( NamedPosition position ) {
        final String fieldName = position.getFieldName();
        if ( fieldName.equals( "tabPanel" ) ) {
            return realPresenter.tabPanel;
        }
        if ( fieldName.equals( "listPanel" ) ) {
            return realPresenter.listPanel;
        }
        if ( fieldName.equals( "simplePanel" ) ) {
            return realPresenter.simplePanel;
        }
        return null;
    }

    @Override
    public PerspectiveDefinition getDefaultPerspectiveLayout() {
        final PerspectiveDefinition p = new PerspectiveDefinitionImpl( TemplatedWorkbenchPanelPresenter.class.getName() );
        p.setName( realPresenter.getClass().getName() );


        PanelDefinition panelDefinition0 = new PanelDefinitionImpl( "org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter" );
        panelDefinition0.addPart(
                new PartDefinitionImpl( new DefaultPlaceRequest( "MoodScreen" ) ) );
        p.getRoot().appendChild( new NamedPosition( "tabPanel" ), panelDefinition0 );
        PanelDefinition panelDefinition1 = new PanelDefinitionImpl( "org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter" );
        panelDefinition1.addPart(
                new PartDefinitionImpl( new DefaultPlaceRequest( "HelloWorldScreen" ) ) );
        p.getRoot().appendChild( new NamedPosition( "listPanel" ), panelDefinition1 );
        PanelDefinition panelDefinition2 = new PanelDefinitionImpl( "org.uberfire.client.workbench.panels.impl.SimpleDnDWorkbenchPanelPresenter" );
        panelDefinition2.addPart(
                new PartDefinitionImpl( new DefaultPlaceRequest( "HomeScreen" ) ) );
        p.getRoot().appendChild( new NamedPosition( "simplePanel" ), panelDefinition2 );
        return p;
    }
}
