/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.file.exports;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;
import org.uberfire.ext.editor.commons.file.exports.PdfFormatValidator;
import org.uberfire.ext.editor.commons.file.exports.PdfOrientationValidator;
import org.uberfire.ext.editor.commons.file.exports.PdfUnitValidator;

public class PdfValidatorsTest {
    private static final PdfOrientationValidator ORIENTATION_VALIDATOR = new PdfOrientationValidator();
    private static final PdfFormatValidator FORMAT_VALIDATOR = new PdfFormatValidator();
    private static final PdfUnitValidator UNIT_VALIDATOR = new PdfUnitValidator();

    @Test
    public void testOrientation() {
        Assert.assertTrue((boolean)ORIENTATION_VALIDATOR.validate((Object)PdfExportPreferences.Orientation.PORTRAIT.name()).isValid());
        Assert.assertTrue((boolean)ORIENTATION_VALIDATOR.validate((Object)PdfExportPreferences.Orientation.LANDSCAPE.name()).isValid());
        Assert.assertFalse((boolean)ORIENTATION_VALIDATOR.validate((Object)"someOrientation").isValid());
    }

    @Test
    public void testFormat() {
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.A0.name()).isValid());
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.A10.name()).isValid());
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.B0.name()).isValid());
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.B10.name()).isValid());
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.C0.name()).isValid());
        Assert.assertTrue((boolean)FORMAT_VALIDATOR.validate((Object)PdfExportPreferences.Format.C10.name()).isValid());
        Assert.assertFalse((boolean)FORMAT_VALIDATOR.validate((Object)"A11").isValid());
    }

    @Test
    public void testUnit() {
        Assert.assertTrue((boolean)UNIT_VALIDATOR.validate((Object)PdfExportPreferences.Unit.MM.name()).isValid());
        Assert.assertTrue((boolean)UNIT_VALIDATOR.validate((Object)PdfExportPreferences.Unit.CM.name()).isValid());
        Assert.assertTrue((boolean)UNIT_VALIDATOR.validate((Object)PdfExportPreferences.Unit.IN.name()).isValid());
        Assert.assertTrue((boolean)UNIT_VALIDATOR.validate((Object)PdfExportPreferences.Unit.PT.name()).isValid());
        Assert.assertFalse((boolean)UNIT_VALIDATOR.validate((Object)"xs").isValid());
    }
}

