/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.backend.service.helper.RenameHelper;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class RenameServiceImpl
implements RenameService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Instance<RenameHelper> helpers;
    @Inject
    private VFSLockService lockService;

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        LOGGER.info("User:" + this.identity.getIdentifier() + " renaming file [" + path.getFileName() + "] to [" + newName + "]");
        LockInfo lockInfo = this.lockService.retrieveLockInfo(path);
        if (lockInfo.isLocked() && !this.identity.getIdentifier().equals(lockInfo.lockedBy())) {
            throw new RuntimeException(path.toURI() + " cannot be renamed. It is locked by: " + lockInfo.lockedBy());
        }
        try {
            Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String originalFileName = _path.getFileName().toString();
            String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
            Path _target = _path.resolveSibling(newName + extension);
            org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
            try {
                this.ioService.startBatch(_target.getFileSystem());
                this.ioService.move(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
                for (RenameHelper helper : this.helpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            return Paths.convert((Path)_target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

