/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.ext.editor.commons.backend.service.CopyServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.ValidationService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.CopyRestrictor;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private User identity;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private VFSLockService lockService;
    @Mock
    private ValidationService validationService;
    @Spy
    @InjectMocks
    private CopyServiceImpl copyService;
    @Spy
    @InjectMocks
    private LockRestrictor lockRestrictor;
    private final List<String> restrictedFileNames = new ArrayList<String>();

    @Before
    public void setup() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        ((CopyServiceImpl)Mockito.doReturn((Object)this.getPath()).when((Object)this.copyService)).copyPath((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        ((CopyServiceImpl)Mockito.doNothing().when((Object)this.copyService)).copyPathIfExists((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        ((CopyServiceImpl)Mockito.doNothing().when((Object)this.copyService)).startBatch((Collection)Matchers.any());
        ((CopyServiceImpl)Mockito.doNothing().when((Object)this.copyService)).endBatch();
        ArrayList<1> copyRestrictors = new ArrayList<1>();
        copyRestrictors.add(new CopyRestrictor(){

            public PathOperationRestriction hasRestriction(Path path) {
                if (CopyServiceImplTest.this.restrictedFileNames.contains(path.getFileName())) {
                    return new PathOperationRestriction(){

                        public String getMessage(Path path) {
                            return path.toURI() + " cannot be copied.";
                        }
                    };
                }
                return null;
            }
        });
        Mockito.when((Object)this.copyService.getCopyRestrictors()).thenReturn(copyRestrictors);
    }

    @Test
    public void copyRestrictedPathTest() {
        Path path = this.getPath("restricted-file.txt");
        this.givenThatPathIsRestricted(path);
        try {
            this.whenPathIsCopied(path);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotCopied(path, e);
        }
        this.thenPathWasNotCopied(path);
    }

    @Test
    public void copyUnrestrictedPathTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnrestricted(path);
        this.whenPathIsCopied(path);
        this.thenPathWasCopied(path);
    }

    @Test
    public void copyRestrictedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnrestricted((Path)paths.get(0));
        this.givenThatPathIsRestricted((Path)paths.get(1));
        this.givenThatPathIsUnrestricted((Path)paths.get(2));
        try {
            this.whenPathsAreCopiedIfExists(paths);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotCopiedIfExists((Path)paths.get(1), e);
        }
        this.thenPathWasCopiedIfExists((Path)paths.get(0));
        this.thenPathWasNotCopiedIfExists((Path)paths.get(1));
        this.thenPathWasNotCopiedIfExists((Path)paths.get(2));
    }

    @Test
    public void copyUnrestrictedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnrestricted((Path)paths.get(0));
        this.givenThatPathIsUnrestricted((Path)paths.get(1));
        this.givenThatPathIsUnrestricted((Path)paths.get(2));
        this.whenPathsAreCopiedIfExists(paths);
        this.thenPathWasCopiedIfExists((Path)paths.get(0));
        this.thenPathWasCopiedIfExists((Path)paths.get(1));
        this.thenPathWasCopiedIfExists((Path)paths.get(2));
    }

    @Test
    public void pathHasNoCopyRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnrestricted(path);
        boolean hasRestriction = this.whenPathIsCheckedForCopyRestrictions(path);
        this.thenPathHasNoCopyRestrictions(hasRestriction);
    }

    @Test
    public void pathHasCopyRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsRestricted(path);
        boolean hasRestriction = this.whenPathIsCheckedForCopyRestrictions(path);
        this.thenPathHasCopyRestrictions(hasRestriction);
    }

    private void givenThatPathIsRestricted(Path path) {
        this.restrictedFileNames.add(path.getFileName());
    }

    private void givenThatPathIsUnrestricted(Path path) {
        this.restrictedFileNames.remove(path.getFileName());
    }

    private void whenPathIsCopied(Path path) {
        this.copyService.copy(path, "newName", "comment");
    }

    private void whenPathsAreCopiedIfExists(Collection<Path> paths) {
        this.copyService.copyIfExists(paths, "newName", "comment");
    }

    private boolean whenPathIsCheckedForCopyRestrictions(Path path) {
        return this.copyService.hasRestriction(path);
    }

    private void thenPathWasCopied(Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopied(Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.never())).copyPath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopied(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be copied."), (Object)e.getMessage());
    }

    private void thenPathWasCopiedIfExists(Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopiedIfExists(Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.never())).copyPathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopiedIfExists(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be copied."), (Object)e.getMessage());
    }

    private void thenPathHasNoCopyRestrictions(boolean hasRestriction) {
        Assert.assertFalse((boolean)hasRestriction);
    }

    private void thenPathHasCopyRestrictions(boolean hasRestriction) {
        Assert.assertTrue((boolean)hasRestriction);
    }

    private Path getPath() {
        return this.getPath("file.txt");
    }

    private Path getPath(String fileName) {
        return PathFactory.newPath((String)fileName, (String)("file://tmp/" + fileName));
    }
}

