/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.backend.service.DeleteServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.ValidationService;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private User identity;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private VFSLockService lockService;
    @Mock
    private ValidationService validationService;
    @Spy
    @InjectMocks
    private DeleteServiceImpl deleteService;
    @Spy
    @InjectMocks
    private LockRestrictor lockRestrictor;

    @Before
    public void setup() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        ((DeleteServiceImpl)Mockito.doNothing().when((Object)this.deleteService)).deletePath((Path)Matchers.any(Path.class), (String)Matchers.any(String.class));
        ((DeleteServiceImpl)Mockito.doNothing().when((Object)this.deleteService)).deletePathIfExists((Path)Matchers.any(Path.class), (String)Matchers.any(String.class));
        ((DeleteServiceImpl)Mockito.doNothing().when((Object)this.deleteService)).startBatch((Collection)Matchers.any());
        ((DeleteServiceImpl)Mockito.doNothing().when((Object)this.deleteService)).endBatch((Collection)Matchers.any());
        ArrayList<LockRestrictor> deleteRestrictors = new ArrayList<LockRestrictor>();
        deleteRestrictors.add(this.lockRestrictor);
        Mockito.when((Object)this.deleteService.getDeleteRestrictors()).thenReturn(deleteRestrictors);
    }

    @Test
    public void deleteLockedPathTest() {
        Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        try {
            this.whenPathIsDeleted(path);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotDeleted(path, e);
        }
        this.thenPathWasNotDeleted(path);
    }

    @Test
    public void deleteUnlockedPathTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        this.whenPathIsDeleted(path);
        this.thenPathWasDeleted(path);
    }

    @Test
    public void deleteLockedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((Path)paths.get(0));
        this.givenThatPathIsLocked((Path)paths.get(1));
        this.givenThatPathIsUnlocked((Path)paths.get(2));
        try {
            this.whenPathsAreDeletedIfExists(paths);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotDeletedIfExists((Path)paths.get(1), e);
        }
        this.thenPathWasDeletedIfExists((Path)paths.get(0));
        this.thenPathWasNotDeletedIfExists((Path)paths.get(1));
        this.thenPathWasNotDeletedIfExists((Path)paths.get(2));
    }

    @Test
    public void deleteUnlockedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((Path)paths.get(0));
        this.givenThatPathIsUnlocked((Path)paths.get(1));
        this.givenThatPathIsUnlocked((Path)paths.get(2));
        this.whenPathsAreDeletedIfExists(paths);
        this.thenPathWasDeletedIfExists((Path)paths.get(0));
        this.thenPathWasDeletedIfExists((Path)paths.get(1));
        this.thenPathWasDeletedIfExists((Path)paths.get(2));
    }

    @Test
    public void pathHasNoDeleteRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForDeleteRestrictions(path);
        this.thenPathHasNoDeleteRestrictions(hasRestriction);
    }

    @Test
    public void pathHasDeleteRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForDeleteRestrictions(path);
        this.thenPathHasDeleteRestrictions(hasRestriction);
    }

    private void givenThatPathIsLocked(Path path) {
        this.changeLockInfo(path, true);
    }

    private void givenThatPathIsUnlocked(Path path) {
        this.changeLockInfo(path, false);
    }

    private void whenPathIsDeleted(Path path) {
        this.deleteService.delete(path, "comment");
    }

    private void whenPathsAreDeletedIfExists(Collection<Path> paths) {
        this.deleteService.deleteIfExists(paths, "comment");
    }

    private boolean whenPathIsCheckedForDeleteRestrictions(Path path) {
        return this.deleteService.hasRestriction(path);
    }

    private void thenPathWasDeleted(Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService)).deletePath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeleted(Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.never())).deletePath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeleted(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathWasDeletedIfExists(Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService)).deletePathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeletedIfExists(Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.never())).deletePathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeletedIfExists(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathHasNoDeleteRestrictions(boolean hasRestriction) {
        Assert.assertFalse((boolean)hasRestriction);
    }

    private void thenPathHasDeleteRestrictions(boolean hasRestriction) {
        Assert.assertTrue((boolean)hasRestriction);
    }

    private Path getPath() {
        return this.getPath("file.txt");
    }

    private Path getPath(String fileName) {
        return PathFactory.newPath((String)fileName, (String)("file://tmp/" + fileName));
    }

    private void changeLockInfo(Path path, boolean locked) {
        Mockito.when((Object)this.lockService.retrieveLockInfo(path)).thenReturn((Object)new LockInfo(locked, "lockedBy", path));
    }
}

