/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URISyntaxException;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.backend.version.VersionServiceImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class VersionServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private PathResolver pathResolver;
    @InjectMocks
    private VersionServiceImpl versionService;

    @Before
    public void setUp() throws Exception {
        User user = (User)Mockito.mock(User.class);
        ((User)Mockito.doReturn((Object)"user id").when((Object)user)).getIdentifier();
        ((SessionInfo)Mockito.doReturn((Object)"session id").when((Object)this.sessionInfo)).getId();
        ((SessionInfo)Mockito.doReturn((Object)user).when((Object)this.sessionInfo)).getIdentity();
    }

    @Test
    public void restore() throws URISyntaxException {
        PathFactory.PathImpl path = new PathFactory.PathImpl("foo.txt", "default://foo.txt");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        ((PathResolver)Mockito.doReturn((Object)nioPath).when((Object)this.pathResolver)).resolveMainFilePath((Path)Matchers.any());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.ioService});
        this.versionService.restore((org.uberfire.backend.vfs.Path)path, "Restore comment");
        ((IOService)order.verify((Object)this.ioService)).startBatch(nioPath.getFileSystem());
        ((IOService)order.verify((Object)this.ioService)).copy((Path)Matchers.eq((Object)nioPath), (Path)Matchers.any(), new CopyOption[]{(CopyOption)Matchers.eq((Object)StandardCopyOption.REPLACE_EXISTING), (CopyOption)Matchers.any(CommentedOption.class)});
        ((IOService)order.verify((Object)this.ioService)).endBatch();
    }
}

