/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.backend.service.DeleteServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.helper.DeleteHelper;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.ValidationService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private User identity;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private VFSLockService lockService;
    @Mock
    private ValidationService validationService;
    @Spy
    @InjectMocks
    private DeleteServiceImpl deleteService;
    @Spy
    @InjectMocks
    private LockRestrictor lockRestrictor;
    @Mock
    private DeleteHelper deleteHelper;

    @Before
    public void setup() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        ArrayList<LockRestrictor> deleteRestrictors = new ArrayList<LockRestrictor>();
        deleteRestrictors.add(this.lockRestrictor);
        Mockito.when((Object)this.deleteService.getDeleteRestrictors()).thenReturn(deleteRestrictors);
        ArrayList<DeleteHelper> deleteHelpers = new ArrayList<DeleteHelper>();
        deleteHelpers.add(this.deleteHelper);
        Mockito.when((Object)this.deleteService.getDeleteHelpers()).thenReturn(deleteHelpers);
        Mockito.when((Object)this.deleteHelper.supports((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)true);
    }

    @Test
    public void deleteLockedPathTest() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        try {
            this.whenPathIsDeleted(path);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotDeleted(path, e);
        }
        this.thenPathWasNotDeleted(path);
    }

    @Test
    public void deleteUnlockedPathTest() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        this.whenPathIsDeleted(path);
        this.thenPathWasDeleted(path);
    }

    @Test
    public void deleteLockedPathIfExistsTest() {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((org.uberfire.backend.vfs.Path)paths.get(0));
        this.givenThatPathIsLocked((org.uberfire.backend.vfs.Path)paths.get(1));
        this.givenThatPathIsUnlocked((org.uberfire.backend.vfs.Path)paths.get(2));
        try {
            this.whenPathsAreDeletedIfExists(paths);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(1), e);
        }
        this.thenPathWasDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(0));
        this.thenPathWasNotDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(1));
        this.thenPathWasNotDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(2));
    }

    @Test
    public void deleteUnlockedPathIfExistsTest() {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((org.uberfire.backend.vfs.Path)paths.get(0));
        this.givenThatPathIsUnlocked((org.uberfire.backend.vfs.Path)paths.get(1));
        this.givenThatPathIsUnlocked((org.uberfire.backend.vfs.Path)paths.get(2));
        this.whenPathsAreDeletedIfExists(paths);
        this.thenPathWasDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(0));
        this.thenPathWasDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(1));
        this.thenPathWasDeletedIfExists((org.uberfire.backend.vfs.Path)paths.get(2));
    }

    @Test
    public void pathHasNoDeleteRestrictionTest() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForDeleteRestrictions(path);
        this.thenPathHasNoDeleteRestrictions(hasRestriction);
    }

    @Test
    public void pathHasDeleteRestrictionTest() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForDeleteRestrictions(path);
        this.thenPathHasDeleteRestrictions(hasRestriction);
    }

    @Test
    public void deletePathInvokesDeleteHelpers() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        this.whenPathIsDeleted(path);
        this.thenIOServiceBatchStarted();
        this.thenDeleteHelperWasInvoked(path);
        this.thenIOServiceBatchEnded();
    }

    @Test
    public void deletePathsIfExistsInvokesDeleteHelpers() {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.whenPathsAreDeletedIfExists(paths);
        this.thenIOServiceBatchStarted();
        this.thenDeleteHelperWasInvoked((org.uberfire.backend.vfs.Path)paths.get(0));
        this.thenDeleteHelperWasInvoked((org.uberfire.backend.vfs.Path)paths.get(1));
        this.thenDeleteHelperWasInvoked((org.uberfire.backend.vfs.Path)paths.get(2));
        this.thenIOServiceBatchEnded();
    }

    @Test
    public void deletePathInvokesDeleteHelpersInCorrectOrder() {
        org.uberfire.backend.vfs.Path path = this.getPath();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.ioService, this.deleteHelper, this.ioService, this.ioService});
        this.whenPathIsDeleted(path);
        ((IOService)order.verify((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((DeleteHelper)order.verify((Object)this.deleteHelper)).postProcess((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path));
        ((IOService)order.verify((Object)this.ioService)).delete((Path)Matchers.any(Path.class), new DeleteOption[]{(DeleteOption)Matchers.any(CommentedOption.class)});
        ((IOService)order.verify((Object)this.ioService)).endBatch();
    }

    private void givenThatPathIsLocked(org.uberfire.backend.vfs.Path path) {
        this.changeLockInfo(path, true);
    }

    private void givenThatPathIsUnlocked(org.uberfire.backend.vfs.Path path) {
        this.changeLockInfo(path, false);
    }

    private void whenPathIsDeleted(org.uberfire.backend.vfs.Path path) {
        this.deleteService.delete(path, "comment");
    }

    private void whenPathsAreDeletedIfExists(Collection<org.uberfire.backend.vfs.Path> paths) {
        this.deleteService.deleteIfExists(paths, "comment");
    }

    private boolean whenPathIsCheckedForDeleteRestrictions(org.uberfire.backend.vfs.Path path) {
        return this.deleteService.hasRestriction(path);
    }

    private void thenPathWasDeleted(org.uberfire.backend.vfs.Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService)).deletePath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeleted(org.uberfire.backend.vfs.Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.never())).deletePath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeleted(org.uberfire.backend.vfs.Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathWasDeletedIfExists(org.uberfire.backend.vfs.Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService)).deletePathIfExists((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeletedIfExists(org.uberfire.backend.vfs.Path path) {
        ((DeleteServiceImpl)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.never())).deletePathIfExists((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotDeletedIfExists(org.uberfire.backend.vfs.Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathHasNoDeleteRestrictions(boolean hasRestriction) {
        Assert.assertFalse((boolean)hasRestriction);
    }

    private void thenPathHasDeleteRestrictions(boolean hasRestriction) {
        Assert.assertTrue((boolean)hasRestriction);
    }

    private void thenIOServiceBatchStarted() {
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
    }

    private void thenIOServiceBatchEnded() {
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
    }

    private void thenDeleteHelperWasInvoked(org.uberfire.backend.vfs.Path path) {
        ((DeleteHelper)Mockito.verify((Object)this.deleteHelper)).postProcess((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path));
    }

    private org.uberfire.backend.vfs.Path getPath() {
        return this.getPath("file.txt");
    }

    private org.uberfire.backend.vfs.Path getPath(String fileName) {
        return PathFactory.newPath((String)fileName, (String)("file://tmp/" + fileName));
    }

    private void changeLockInfo(org.uberfire.backend.vfs.Path path, boolean locked) {
        Mockito.when((Object)this.lockService.retrieveLockInfo(path)).thenReturn((Object)new LockInfo(locked, "lockedBy", path));
    }
}

