/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.ext.editor.commons.backend.service.CopyServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.naming.PathNamingServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.ext.editor.commons.service.ValidationService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.CopyRestrictor;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceCopiedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyServiceImplTest {
    private static final String PATH_PREFIX = "git://amend-repo-test/";
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private final List<String> restrictedFileNames = new ArrayList<String>();
    @Spy
    private Event<ResourceCopiedEvent> resourceCopiedEvent = new EventSourceMock();
    @Mock
    private Instance<CopyRestrictor> copyRestrictorBeans;
    @Mock
    private User identity;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private VFSLockService lockService;
    @Mock
    private ValidationService validationService;
    @Spy
    private PathNamingServiceImpl pathNamingService = new PathNamingServiceImpl();
    private CopyServiceImpl copyService;
    @Spy
    @InjectMocks
    private LockRestrictor lockRestrictor;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        this.copyService = (CopyServiceImpl)Mockito.spy((Object)new CopyServiceImpl(fileSystemTestingUtils.getIoService(), this.identity, this.sessionInfo, null, this.resourceCopiedEvent, this.copyRestrictorBeans, (PathNamingService)this.pathNamingService));
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        ((PathNamingServiceImpl)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.pathNamingService)).getResourceTypeDefinitions();
        this.mockCopyRestrictors();
        ((Event)Mockito.doNothing().when(this.resourceCopiedEvent)).fire(Matchers.any(ResourceCopiedEvent.class));
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void copyRestrictedPathTest() {
        org.uberfire.backend.vfs.Path path = this.createFile("restricted-file.txt");
        this.givenThatPathIsRestricted(path);
        try {
            this.whenPathIsCopied(path);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotCopied(path, e);
        }
        this.thenPathWasNotCopied(path);
    }

    @Test
    public void copyUnrestrictedPathTest() {
        org.uberfire.backend.vfs.Path path = this.createFile();
        this.givenThatPathIsUnrestricted(path);
        this.whenPathIsCopied(path);
        this.thenPathWasCopied(path);
    }

    @Test
    public void copyRestrictedPathIfExistsTest() {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        paths.add(this.createFile("file0.txt"));
        paths.add(this.createFile("file1.txt"));
        paths.add(this.createFile("file2.txt"));
        this.givenThatPathIsUnrestricted((org.uberfire.backend.vfs.Path)paths.get(0));
        this.givenThatPathIsRestricted((org.uberfire.backend.vfs.Path)paths.get(1));
        this.givenThatPathIsUnrestricted((org.uberfire.backend.vfs.Path)paths.get(2));
        try {
            this.whenPathsAreCopiedIfExists(paths);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(1), e);
        }
        this.thenPathWasCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(0));
        this.thenPathWasNotCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(1));
        this.thenPathWasNotCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(2));
    }

    @Test
    public void copyUnrestrictedPathIfExistsTest() {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        paths.add(this.createFile("dir1/file1.txt"));
        paths.add(this.createFile("dir2/file2.txt"));
        paths.add(this.createFile("dir3/file3.txt"));
        this.givenThatPathIsUnrestricted((org.uberfire.backend.vfs.Path)paths.get(0));
        this.givenThatPathIsUnrestricted((org.uberfire.backend.vfs.Path)paths.get(1));
        this.givenThatPathIsUnrestricted((org.uberfire.backend.vfs.Path)paths.get(2));
        this.whenPathsAreCopiedIfExists(paths);
        this.thenPathWasCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(0));
        this.thenPathWasCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(1));
        this.thenPathWasCopiedIfExists((org.uberfire.backend.vfs.Path)paths.get(2));
    }

    @Test
    public void pathHasNoCopyRestrictionTest() {
        org.uberfire.backend.vfs.Path path = this.createFile();
        this.givenThatPathIsUnrestricted(path);
        boolean hasRestriction = this.whenPathIsCheckedForCopyRestrictions(path);
        this.thenPathHasNoCopyRestrictions(hasRestriction);
    }

    @Test
    public void pathHasCopyRestrictionTest() {
        org.uberfire.backend.vfs.Path path = this.createFile();
        this.givenThatPathIsRestricted(path);
        boolean hasRestriction = this.whenPathIsCheckedForCopyRestrictions(path);
        this.thenPathHasCopyRestrictions(hasRestriction);
    }

    @Test
    public void copyFileToAnotherDirectory() {
        org.uberfire.backend.vfs.Path path = this.createFile();
        String newName = "new-name";
        org.uberfire.backend.vfs.Path targetDirectory = this.getAnotherDirectory();
        this.givenThatPathIsUnrestricted(path);
        this.whenPathIsCopiedToAnotherDirectory(path, "new-name", targetDirectory);
        this.thenPathWasCopiedToAnotherDirectory(path, "new-name", targetDirectory);
    }

    @Test
    public void copyFileToNullDirectory() {
        org.uberfire.backend.vfs.Path path = this.createFile();
        String newName = "new-name";
        this.givenThatPathIsUnrestricted(path);
        this.whenPathIsCopiedToAnotherDirectory(path, "new-name", null);
        this.thenPathWasCopiedToSameDirectory(path, "new-name");
    }

    private void givenThatPathIsRestricted(org.uberfire.backend.vfs.Path path) {
        this.restrictedFileNames.add(path.getFileName());
    }

    private void givenThatPathIsUnrestricted(org.uberfire.backend.vfs.Path path) {
        this.restrictedFileNames.remove(path.getFileName());
    }

    private void whenPathIsCopied(org.uberfire.backend.vfs.Path path) {
        this.copyService.copy(path, "newName", "comment");
    }

    private void whenPathIsCopiedToAnotherDirectory(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory) {
        this.copyService.copy(path, newName, targetDirectory, "comment");
    }

    private void whenPathsAreCopiedIfExists(Collection<org.uberfire.backend.vfs.Path> paths) {
        this.copyService.copyIfExists(paths, "newName", "comment");
    }

    private boolean whenPathIsCheckedForCopyRestrictions(org.uberfire.backend.vfs.Path path) {
        return this.copyService.hasRestriction(path);
    }

    private void thenPathWasCopied(org.uberfire.backend.vfs.Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), (String)Matchers.any(String.class));
        ((Event)Mockito.verify(this.resourceCopiedEvent)).fire(Matchers.any(ResourceCopiedEvent.class));
    }

    private void thenPathWasCopiedToAnotherDirectory(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory) {
        org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)targetDirectory).resolve(newName + ".txt"));
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)targetPath), (String)Matchers.any(String.class));
    }

    private void thenPathWasCopiedToSameDirectory(org.uberfire.backend.vfs.Path path, String newName) {
        org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().resolve(newName + ".txt"));
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)targetPath), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopied(org.uberfire.backend.vfs.Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.never())).copyPath((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopied(org.uberfire.backend.vfs.Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be copied."), (Object)e.getMessage());
    }

    private void thenPathWasCopiedIfExists(org.uberfire.backend.vfs.Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService)).copyPathIfExists((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopiedIfExists(org.uberfire.backend.vfs.Path path) {
        ((CopyServiceImpl)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.never())).copyPathIfExists((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotCopiedIfExists(org.uberfire.backend.vfs.Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be copied."), (Object)e.getMessage());
    }

    private void thenPathHasNoCopyRestrictions(boolean hasRestriction) {
        Assert.assertFalse((boolean)hasRestriction);
    }

    private void thenPathHasCopyRestrictions(boolean hasRestriction) {
        Assert.assertTrue((boolean)hasRestriction);
    }

    private org.uberfire.backend.vfs.Path createFile() {
        return this.createFile("file.txt");
    }

    private org.uberfire.backend.vfs.Path createFile(String fileName) {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)fileName, (String)("git://amend-repo-test/parent/" + fileName));
        fileSystemTestingUtils.getIoService().write(Paths.convert((org.uberfire.backend.vfs.Path)path), "content", new OpenOption[0]);
        return path;
    }

    private org.uberfire.backend.vfs.Path getAnotherDirectory() {
        return PathFactory.newPath((String)"/", (String)"git://amend-repo-test/new-parent/");
    }

    private void mockCopyRestrictors() {
        ArrayList<1> copyRestrictors = new ArrayList<1>();
        copyRestrictors.add(new CopyRestrictor(){

            public PathOperationRestriction hasRestriction(org.uberfire.backend.vfs.Path path) {
                if (CopyServiceImplTest.this.restrictedFileNames.contains(path.getFileName())) {
                    return new PathOperationRestriction(){

                        public String getMessage(org.uberfire.backend.vfs.Path path) {
                            return path.toURI() + " cannot be copied.";
                        }
                    };
                }
                return null;
            }
        });
        Mockito.when((Object)this.copyService.getCopyRestrictors()).thenReturn(copyRestrictors);
    }
}

