/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.backend.service.RenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.ValidationService;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class RenameServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private User identity;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private VFSLockService lockService;
    @Mock
    private ValidationService validationService;
    @Spy
    @InjectMocks
    private RenameServiceImpl renameService;
    @Spy
    @InjectMocks
    private LockRestrictor lockRestrictor;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        ((RenameServiceImpl)Mockito.doReturn((Object)this.getPath()).when((Object)this.renameService)).renamePath((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        ((RenameServiceImpl)Mockito.doNothing().when((Object)this.renameService)).renamePathIfExists((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        ((RenameServiceImpl)Mockito.doNothing().when((Object)this.renameService)).startBatch((Collection)Matchers.any());
        ((RenameServiceImpl)Mockito.doNothing().when((Object)this.renameService)).endBatch();
        ArrayList<LockRestrictor> renameRestrictors = new ArrayList<LockRestrictor>();
        renameRestrictors.add(this.lockRestrictor);
        Mockito.when((Object)this.renameService.getRenameRestrictors()).thenReturn(renameRestrictors);
    }

    @Test
    public void renameLockedPathTest() {
        Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        try {
            this.whenPathIsRenamed(path);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotRenamed(path, e);
        }
        this.thenPathWasNotRenamed(path);
    }

    @Test
    public void renameUnlockedPathTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        this.whenPathIsRenamed(path);
        this.thenPathWasRenamed(path);
    }

    @Test
    public void renameLockedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((Path)paths.get(0));
        this.givenThatPathIsLocked((Path)paths.get(1));
        this.givenThatPathIsUnlocked((Path)paths.get(2));
        try {
            this.whenPathsAreRenamedIfExists(paths);
        }
        catch (RuntimeException e) {
            this.thenPathWasNotRenamedIfExists((Path)paths.get(1), e);
        }
        this.thenPathWasRenamedIfExists((Path)paths.get(0));
        this.thenPathWasNotRenamedIfExists((Path)paths.get(1));
        this.thenPathWasNotRenamedIfExists((Path)paths.get(2));
    }

    @Test
    public void renameUnlockedPathIfExistsTest() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getPath("file0.txt"));
        paths.add(this.getPath("file1.txt"));
        paths.add(this.getPath("file2.txt"));
        this.givenThatPathIsUnlocked((Path)paths.get(0));
        this.givenThatPathIsUnlocked((Path)paths.get(1));
        this.givenThatPathIsUnlocked((Path)paths.get(2));
        this.whenPathsAreRenamedIfExists(paths);
        this.thenPathWasRenamedIfExists((Path)paths.get(0));
        this.thenPathWasRenamedIfExists((Path)paths.get(1));
        this.thenPathWasRenamedIfExists((Path)paths.get(2));
    }

    @Test
    public void pathHasNoRenameRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsUnlocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForRenameRestrictions(path);
        this.thenPathHasNoRenameRestrictions(hasRestriction);
    }

    @Test
    public void pathHasRenameRestrictionTest() {
        Path path = this.getPath();
        this.givenThatPathIsLocked(path);
        boolean hasRestriction = this.whenPathIsCheckedForRenameRestrictions(path);
        this.thenPathHasRenameRestrictions(hasRestriction);
    }

    private void givenThatPathIsLocked(Path path) {
        this.changeLockInfo(path, true);
    }

    private void givenThatPathIsUnlocked(Path path) {
        this.changeLockInfo(path, false);
    }

    private void whenPathIsRenamed(Path path) {
        this.renameService.rename(path, "newname", "comment");
    }

    private void whenPathsAreRenamedIfExists(Collection<Path> paths) {
        this.renameService.renameIfExists(paths, "newname", "comment");
    }

    private boolean whenPathIsCheckedForRenameRestrictions(Path path) {
        return this.renameService.hasRestriction(path);
    }

    private void thenPathWasRenamed(Path path) {
        ((RenameServiceImpl)Mockito.verify((Object)this.renameService)).renamePath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotRenamed(Path path) {
        ((RenameServiceImpl)Mockito.verify((Object)this.renameService, (VerificationMode)Mockito.never())).renamePath((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotRenamed(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathWasRenamedIfExists(Path path) {
        ((RenameServiceImpl)Mockito.verify((Object)this.renameService)).renamePathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotRenamedIfExists(Path path) {
        ((RenameServiceImpl)Mockito.verify((Object)this.renameService, (VerificationMode)Mockito.never())).renamePathIfExists((Path)Mockito.eq((Object)path), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    private void thenPathWasNotRenamedIfExists(Path path, RuntimeException e) {
        Assert.assertEquals((Object)(path.toURI() + " cannot be deleted, moved or renamed. It is locked by: lockedBy"), (Object)e.getMessage());
    }

    private void thenPathHasNoRenameRestrictions(boolean hasRestriction) {
        Assert.assertFalse((boolean)hasRestriction);
    }

    private void thenPathHasRenameRestrictions(boolean hasRestriction) {
        Assert.assertTrue((boolean)hasRestriction);
    }

    private Path getPath() {
        return this.getPath("file.txt");
    }

    private Path getPath(String fileName) {
        return PathFactory.newPath((String)fileName, (String)("file://tmp/" + fileName));
    }

    private void changeLockInfo(Path path, boolean locked) {
        Mockito.when((Object)this.lockService.retrieveLockInfo(path)).thenReturn((Object)new LockInfo(locked, "lockedBy", path));
    }
}

