/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.restriction;

import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.backend.service.restriction.LockRestrictor;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;

@RunWith(value=MockitoJUnitRunner.class)
public class LockRestrictorTest {
    @Mock
    private VFSLockService lockService;
    @Mock
    private User identity;
    @InjectMocks
    private LockRestrictor lockRestrictor;
    @Mock
    private Path path;
    @Mock
    private PathOperationRestriction pathOperationRestriction;
    @Mock
    private LockInfo lockInfo;
    @Mock
    private List<LockInfo> lockInfos;

    @Before
    public void setup() {
    }

    @Test
    public void lockFromAnotherUserShouldCauseRestriction() {
        Mockito.when((Object)this.lockInfo.isLocked()).thenReturn((Object)true);
        Mockito.when((Object)this.lockService.retrieveLockInfo((Path)ArgumentMatchers.any())).thenReturn((Object)this.lockInfo);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"456");
        Mockito.when((Object)this.lockInfo.lockedBy()).thenReturn((Object)"123");
        PathOperationRestriction result = this.lockRestrictor.hasRestriction(this.path);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof PathOperationRestriction));
    }

    @Test
    public void lockedFilesShouldCauseRestriction() {
        Mockito.when((Object)this.lockInfo.isLocked()).thenReturn((Object)false);
        Mockito.when((Object)this.lockService.retrieveLockInfo((Path)ArgumentMatchers.any())).thenReturn((Object)this.lockInfo);
        Mockito.when((Object)this.lockService.retrieveLockInfos(this.path, true)).thenReturn(this.lockInfos);
        Mockito.when((Object)this.lockInfos.isEmpty()).thenReturn((Object)false);
        PathOperationRestriction result = this.lockRestrictor.hasRestriction(this.path);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof PathOperationRestriction));
    }

    @Test
    public void noLockShouldNotCauseRestriction() {
        Mockito.when((Object)this.lockInfo.isLocked()).thenReturn((Object)false);
        Mockito.when((Object)this.lockService.retrieveLockInfo((Path)ArgumentMatchers.any())).thenReturn((Object)this.lockInfo);
        Mockito.when((Object)this.lockService.retrieveLockInfos(this.path, true)).thenReturn(this.lockInfos);
        Mockito.when((Object)this.lockInfos.isEmpty()).thenReturn((Object)true);
        PathOperationRestriction result = this.lockRestrictor.hasRestriction(this.path);
        Assert.assertNull((Object)result);
    }

    @Test
    public void lockBySameUserShouldNotCauseRestriction() {
        Mockito.when((Object)this.lockInfo.isLocked()).thenReturn((Object)true);
        Mockito.when((Object)this.lockService.retrieveLockInfo((Path)ArgumentMatchers.any())).thenReturn((Object)this.lockInfo);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"123");
        Mockito.when((Object)this.lockInfo.lockedBy()).thenReturn((Object)"123");
        Mockito.when((Object)this.lockService.retrieveLockInfos(this.path, true)).thenReturn(this.lockInfos);
        Mockito.when((Object)this.lockInfos.isEmpty()).thenReturn((Object)true);
        PathOperationRestriction result = this.lockRestrictor.hasRestriction(this.path);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyRestrictionListShouldNotCauseRestriction() {
        Mockito.when((Object)this.lockInfo.isLocked()).thenReturn((Object)false);
        Mockito.when((Object)this.lockService.retrieveLockInfo((Path)ArgumentMatchers.any())).thenReturn((Object)this.lockInfo);
        Mockito.when((Object)this.lockInfos.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.lockService.retrieveLockInfos(this.path, true)).thenReturn(this.lockInfos);
        PathOperationRestriction result = this.lockRestrictor.hasRestriction(this.path);
        Assert.assertNull((Object)result);
    }
}

