/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.mvp.PlaceRequest;

public class KieEditorTest {
    private BaseEditor kieEditor;
    private BaseEditorView view;

    @Before
    public void setUp() throws Exception {
        this.view = (BaseEditorView)Mockito.mock(BaseEditorView.class);
        this.kieEditor = (BaseEditor)Mockito.spy((Object)new BaseEditor(this.view){

            protected void loadContent() {
            }

            protected void showVersions() {
            }

            protected void makeMenuBar() {
            }

            protected void showConcurrentUpdatePopup() {
            }
        });
        this.kieEditor.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ClientResourceType resourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        this.kieEditor.init(observablePath, placeRequest, resourceType, new MenuItems[0]);
    }

    @Test
    public void testLoad() throws Exception {
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).loadContent();
    }

    @Test
    public void testSimpleSave() throws Exception {
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testComplicatedSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testSaveReadOnly() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditorView)Mockito.verify((Object)this.view)).alertReadOnly();
    }

    @Test
    public void testRestore() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)false);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager)).restoreToCurrentVersion();
    }

    @Test
    public void testConcurrentSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.concurrentUpdateSessionInfo = new ObservablePath.OnConcurrentUpdateEvent(){

            public Path getPath() {
                return null;
            }

            public String getId() {
                return null;
            }

            public User getIdentity() {
                return null;
            }
        };
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).showConcurrentUpdatePopup();
    }
}

