/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.editor.commons.client.file.RestorePopup;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.history.Helper;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButton;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.history.VersionSelectedEventMock;
import org.uberfire.ext.editor.commons.client.history.VersionServiceCallerMock;
import org.uberfire.ext.editor.commons.client.history.event.VersionSelectedEvent;
import org.uberfire.java.nio.base.version.VersionRecord;

public class VersionRecordManagerTest {
    private VersionRecordManager manager;
    private ArrayList<VersionRecord> versions = new ArrayList();
    private RestorePopup restorePopup;
    private RestoreUtil util;
    private VersionMenuDropDownButton dropDownButton;
    private ObservablePath pathTo111;
    private ObservablePath pathTo222;
    private ObservablePath pathTo333;
    private VersionSelectedEventMock versionSelectedEvent;

    @Before
    public void setUp() throws Exception {
        this.dropDownButton = (VersionMenuDropDownButton)Mockito.mock(VersionMenuDropDownButton.class);
        this.restorePopup = (RestorePopup)Mockito.mock(RestorePopup.class);
        this.setUpUtil();
        this.setUpVersions();
        this.versionSelectedEvent = (VersionSelectedEventMock)Mockito.spy((Object)new VersionSelectedEventMock(new Callback<VersionSelectedEvent>(){

            public void callback(VersionSelectedEvent result) {
                VersionRecordManagerTest.this.manager.onVersionSelectedEvent(result);
            }
        }));
        this.manager = (VersionRecordManager)Mockito.spy((Object)new VersionRecordManager(this.dropDownButton, this.restorePopup, this.util, (Event)this.versionSelectedEvent, (Caller)new VersionServiceCallerMock(this.versions)));
        this.manager.init(null, this.pathTo333, (Callback)new Callback<VersionRecord>(){

            public void callback(VersionRecord result) {
                VersionRecordManagerTest.this.manager.setVersion(result.id());
            }
        });
    }

    private void setUpVersions() {
        this.versions.add(Helper.getVersionRecord("111"));
        this.versions.add(Helper.getVersionRecord("222"));
        this.versions.add(Helper.getVersionRecord("333"));
    }

    private void setUpUtil() {
        this.util = (RestoreUtil)Mockito.mock(RestoreUtil.class);
        this.pathTo111 = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.pathTo222 = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.pathTo333 = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)this.pathTo111.toURI()).thenReturn((Object)"hehe//111");
        Mockito.when((Object)this.pathTo222.toURI()).thenReturn((Object)"hehe//222");
        Mockito.when((Object)this.pathTo333.toURI()).thenReturn((Object)"hehe//333");
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//111")).thenReturn((Object)this.pathTo111);
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//222")).thenReturn((Object)this.pathTo222);
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//333")).thenReturn((Object)this.pathTo333);
    }

    @Test
    public void testSimple() throws Exception {
        ((VersionMenuDropDownButton)Mockito.verify((Object)this.dropDownButton)).setItems(this.versions);
        Assert.assertEquals((Object)this.pathTo333, (Object)this.manager.getCurrentPath());
        Assert.assertEquals((Object)this.pathTo333, (Object)this.manager.getPathToLatest());
        Assert.assertEquals((Object)"333", (Object)this.manager.getVersion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionToNull() throws Exception {
        this.manager.setVersion(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionsNull() throws Exception {
        this.manager.setVersions(null);
    }

    @Test
    public void testVersionChange() throws Exception {
        this.manager.onVersionSelectedEvent(new VersionSelectedEvent((Path)this.pathTo333, Helper.getVersionRecord("111")));
        Assert.assertEquals((Object)this.pathTo111, (Object)this.manager.getCurrentPath());
        Assert.assertEquals((Object)"111", (Object)this.manager.getVersion());
    }

    @Test
    public void testReset() throws Exception {
        this.manager.onVersionSelectedEvent(new VersionSelectedEvent((Path)this.pathTo333, Helper.getVersionRecord("111")));
        this.manager.restoreToCurrentVersion();
        ((RestorePopup)Mockito.verify((Object)this.restorePopup)).show(this.pathTo111, "hehe//111");
    }

    @Test
    public void testReload() throws Exception {
        this.versions.add(Helper.getVersionRecord("444"));
        ObservablePath pathTo444 = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)pathTo444.toURI()).thenReturn((Object)"hehe//444");
        Mockito.when((Object)this.util.createObservablePath((Path)pathTo444, "hehe//444")).thenReturn((Object)pathTo444);
        this.manager.reloadVersions((Path)pathTo444);
        Assert.assertEquals((Object)pathTo444, (Object)this.manager.getPathToLatest());
        Assert.assertEquals((Object)pathTo444, (Object)this.manager.getCurrentPath());
        Assert.assertEquals((Object)"444", (Object)this.manager.getVersion());
    }

    @Test
    public void testInitNeedsToClearTheState() throws Exception {
        ((VersionRecordManager)Mockito.verify((Object)this.manager)).clear();
    }
}

