/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.editor.commons.client.file.RestorePopup;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButton;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.history.VersionSelectedEventMock;
import org.uberfire.ext.editor.commons.client.history.VersionServiceCallerMock;
import org.uberfire.ext.editor.commons.client.history.event.VersionSelectedEvent;
import org.uberfire.java.nio.base.version.VersionRecord;

public class VersionRecordManagerOpenOlderVersionTest {
    private VersionRecordManager manager;
    private ArrayList<VersionRecord> versions = new ArrayList();
    private RestorePopup restorePopup;
    private RestoreUtil util;
    private VersionMenuDropDownButton dropDownButton;
    private ObservablePath pathTo111;
    private ObservablePath pathTo222;
    private ObservablePath pathTo333;

    @Before
    public void setUp() throws Exception {
        this.dropDownButton = (VersionMenuDropDownButton)Mockito.mock(VersionMenuDropDownButton.class);
        this.restorePopup = (RestorePopup)Mockito.mock(RestorePopup.class);
        this.setUpUtil();
        this.setUpVersions();
        this.manager = new VersionRecordManager(this.dropDownButton, this.restorePopup, this.util, (Event)new VersionSelectedEventMock(new Callback<VersionSelectedEvent>(){

            public void callback(VersionSelectedEvent result) {
                VersionRecordManagerOpenOlderVersionTest.this.manager.onVersionSelectedEvent(result);
            }
        }), (Caller)new VersionServiceCallerMock(this.versions));
    }

    private void setUpVersions() {
        this.versions.add(this.getVersionRecord("111"));
        this.versions.add(this.getVersionRecord("222"));
        this.versions.add(this.getVersionRecord("333"));
    }

    private void setUpUtil() {
        this.util = (RestoreUtil)Mockito.mock(RestoreUtil.class);
        this.pathTo111 = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.pathTo222 = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.pathTo333 = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)this.pathTo111.toURI()).thenReturn((Object)"hehe//111");
        Mockito.when((Object)this.pathTo222.toURI()).thenReturn((Object)"hehe//222");
        Mockito.when((Object)this.pathTo333.toURI()).thenReturn((Object)"hehe//333");
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//111")).thenReturn((Object)this.pathTo111);
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//222")).thenReturn((Object)this.pathTo222);
        Mockito.when((Object)this.util.createObservablePath((Path)this.pathTo333, "hehe//333")).thenReturn((Object)this.pathTo333);
    }

    @Test
    public void testOpenOlder() throws Exception {
        this.manager.init("222", this.pathTo333, (Callback)new Callback<VersionRecord>(){

            public void callback(VersionRecord result) {
                VersionRecordManagerOpenOlderVersionTest.this.manager.setVersion(result.id());
            }
        });
        Assert.assertEquals((Object)this.pathTo222, (Object)this.manager.getCurrentPath());
        Assert.assertEquals((Object)this.pathTo333, (Object)this.manager.getPathToLatest());
        Assert.assertEquals((Object)"222", (Object)this.manager.getVersion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOpenUnknownVersion() throws Exception {
        this.manager.init("xxx", this.pathTo333, (Callback)new Callback<VersionRecord>(){

            public void callback(VersionRecord result) {
                VersionRecordManagerOpenOlderVersionTest.this.manager.setVersion(result.id());
            }
        });
    }

    private VersionRecord getVersionRecord(String version) {
        VersionRecord versionRecord = (VersionRecord)Mockito.mock(VersionRecord.class);
        Mockito.when((Object)versionRecord.id()).thenReturn((Object)version);
        Mockito.when((Object)versionRecord.uri()).thenReturn((Object)("hehe//" + version));
        return versionRecord;
    }
}

